/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.interfaces.world.IMixinDimensionType;
import org.spongepowered.common.interfaces.world.IMixinGameRules;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.registry.type.entity.GameModeRegistryModule;
import org.spongepowered.common.registry.type.world.DimensionTypeRegistryModule;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.common.registry.type.world.WorldGeneratorModifierRegistryModule;
import org.spongepowered.common.util.FunctionalUtil;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldManager;

@NonnullByDefault
@Mixin(value={WorldInfo.class})
@Implements(value={@Interface(iface=WorldProperties.class, prefix="worldproperties$")})
public abstract class MixinWorldInfo
implements WorldProperties,
IMixinWorldInfo {
    @Shadow
    private long field_76100_a;
    @Shadow
    private WorldType field_76098_b;
    @Shadow
    private String field_82576_c;
    @Shadow
    private int field_76099_c;
    @Shadow
    private int field_76096_d;
    @Shadow
    private int field_76097_e;
    @Shadow
    private long field_82575_g;
    @Shadow
    private long field_76094_f;
    @Shadow
    private long field_76095_g;
    @Shadow
    private long field_76107_h;
    @Shadow
    private NBTTagCompound field_76108_i;
    @Shadow
    private String field_76106_k;
    @Shadow
    private int field_76103_l;
    @Shadow
    private int field_176157_p;
    @Shadow
    private boolean field_76104_m;
    @Shadow
    private int field_76101_n;
    @Shadow
    private boolean field_76102_o;
    @Shadow
    private int field_76114_p;
    @Shadow
    private GameType field_76113_q;
    @Shadow
    private boolean field_76112_r;
    @Shadow
    private boolean field_76111_s;
    @Shadow
    private boolean field_76110_t;
    @Shadow
    private boolean field_76109_u;
    @Shadow
    private EnumDifficulty field_176158_z;
    @Shadow
    private boolean field_176150_A;
    @Shadow
    private double field_176151_B;
    @Shadow
    private double field_176152_C;
    @Shadow
    private double field_176146_D;
    @Shadow
    private long field_176147_E;
    @Shadow
    private double field_176148_F;
    @Shadow
    private double field_176149_G;
    @Shadow
    private double field_176153_H;
    @Shadow
    private int field_176154_I;
    @Shadow
    private int field_176155_J;
    @Shadow
    private GameRules field_82577_x;
    private UUID uuid;
    private Integer dimensionId;
    private DimensionType dimensionType = DimensionTypes.OVERWORLD;
    private SerializationBehavior serializationBehavior = SerializationBehaviors.AUTOMATIC;
    private boolean isMod = false;
    private boolean generateBonusChest;
    private boolean isValid = true;
    private NBTTagCompound spongeRootLevelNbt = new NBTTagCompound();
    private NBTTagCompound spongeNbt = new NBTTagCompound();
    private NBTTagList playerUniqueIdNbt = new NBTTagList();
    private BiMap<Integer, UUID> playerUniqueIdMap = HashBiMap.create();
    private List<UUID> pendingUniqueIds = new ArrayList<UUID>();
    private int trackedUniqueIdCount = 0;
    private SpongeConfig<WorldConfig> worldConfig;
    private ServerScoreboard scoreboard;
    private PortalAgentType portalAgentType;

    @Shadow
    public abstract NBTTagCompound func_76082_a(NBTTagCompound var1);

    @Inject(method="<init>", at={@At(value="RETURN")})
    public void onConstruction(CallbackInfo ci) {
        this.spongeNbt.func_74782_a("PlayerIdTable", (NBTBase)this.playerUniqueIdNbt);
        this.spongeRootLevelNbt.func_74782_a("SpongeData", (NBTBase)this.spongeNbt);
    }

    @Inject(method="<init>*", at={@At(value="RETURN")})
    public void onConstruction(NBTTagCompound nbt, CallbackInfo ci) {
        if (!SpongeCommonEventFactory.convertingMapFormat) {
            this.onConstruction(ci);
        }
    }

    @Inject(method="<init>*", at={@At(value="RETURN")})
    public void onConstruction(WorldSettings settings, String name, CallbackInfo ci) {
        if (name.equals("MpServer") || name.equals("sponge$dummy_world")) {
            this.isValid = false;
            return;
        }
        this.onConstruction(ci);
        WorldArchetype archetype = (WorldArchetype)settings;
        this.setDimensionType(archetype.getDimensionType());
        this.createWorldConfig();
        this.setEnabled(archetype.isEnabled());
        this.setLoadOnStartup(archetype.loadOnStartup());
        this.setKeepSpawnLoaded(archetype.doesKeepSpawnLoaded());
        this.setGenerateSpawnOnLoad(archetype.doesGenerateSpawnOnLoad());
        this.setDifficulty(archetype.getDifficulty());
        Collection<WorldGeneratorModifier> modifiers = this.getGeneratorModifiers();
        if (modifiers.isEmpty()) {
            this.setGeneratorModifiers(archetype.getGeneratorModifiers());
        } else {
            this.setGeneratorModifiers(modifiers);
        }
        this.setDoesGenerateBonusChest(archetype.doesGenerateBonusChest());
        this.setSerializationBehavior(archetype.getSerializationBehavior());
        this.getOrCreateWorldConfig().save();
    }

    @Inject(method="<init>*", at={@At(value="RETURN")})
    public void onConstruction(WorldInfo worldInformation, CallbackInfo ci) {
        this.onConstruction(ci);
        MixinWorldInfo info = (MixinWorldInfo)worldInformation;
        this.portalAgentType = info.portalAgentType;
        this.setDimensionType(info.dimensionType);
    }

    @Inject(method="updateTagCompound", at={@At(value="HEAD")})
    private void ensureLevelNameMatchesDirectory(NBTTagCompound compound, NBTTagCompound player, CallbackInfo ci) {
        if (this.dimensionId == null) {
            return;
        }
        String name = WorldManager.getWorldFolderByDimensionId(this.dimensionId).orElse(this.field_76106_k);
        if (!this.field_76106_k.equalsIgnoreCase(name)) {
            this.field_76106_k = name;
        }
    }

    @Override
    public boolean createWorldConfig() {
        if (this.worldConfig != null) {
            return false;
        }
        this.worldConfig = new SpongeConfig(SpongeConfig.Type.WORLD, ((IMixinDimensionType)((Object)this.dimensionType)).getConfigPath().resolve(this.field_76106_k).resolve("world.conf"), "sponge");
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public Vector3i getSpawnPosition() {
        return new Vector3i(this.field_76099_c, this.field_76096_d, this.field_76097_e);
    }

    @Override
    public void setSpawnPosition(Vector3i position) {
        Preconditions.checkNotNull((Object)position);
        this.field_76099_c = position.getX();
        this.field_76096_d = position.getY();
        this.field_76097_e = position.getZ();
    }

    @Override
    public GeneratorType getGeneratorType() {
        return (GeneratorType)this.field_76098_b;
    }

    @Override
    public void setGeneratorType(GeneratorType type) {
        this.field_76098_b = (WorldType)type;
    }

    @Intrinsic
    public long worldproperties$getSeed() {
        return this.field_76100_a;
    }

    @Override
    public void setSeed(long seed) {
        this.field_76100_a = seed;
    }

    @Override
    public long getTotalTime() {
        return this.field_82575_g;
    }

    @Intrinsic
    public long worldproperties$getWorldTime() {
        return this.field_76094_f;
    }

    @Override
    public void setWorldTime(long time) {
        this.field_76094_f = time;
    }

    @Override
    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public void setDimensionType(DimensionType type) {
        this.dimensionType = type;
        String modId = SpongeImplHooks.getModIdFromClass(this.dimensionType.getDimensionClass());
        if (!modId.equals("minecraft")) {
            this.isMod = true;
        }
    }

    @Override
    public PortalAgentType getPortalAgentType() {
        if (this.portalAgentType == null) {
            this.portalAgentType = PortalAgentTypes.DEFAULT;
        }
        return this.portalAgentType;
    }

    @Override
    public void setPortalAgentType(PortalAgentType type) {
        this.portalAgentType = type;
    }

    @Intrinsic
    public String worldproperties$getWorldName() {
        return this.field_76106_k;
    }

    @Intrinsic
    public boolean worldproperties$isRaining() {
        return this.field_76104_m;
    }

    @Override
    public void setRaining(boolean state) {
        this.field_76104_m = state;
    }

    @Intrinsic
    public int worldproperties$getRainTime() {
        return this.field_76101_n;
    }

    @Intrinsic
    public void worldproperties$setRainTime(int time) {
        this.field_76101_n = time;
    }

    @Intrinsic
    public boolean worldproperties$isThundering() {
        return this.field_76102_o;
    }

    @Intrinsic
    public void worldproperties$setThundering(boolean state) {
        this.field_76102_o = state;
    }

    @Override
    public int getThunderTime() {
        return this.field_76114_p;
    }

    @Override
    public void setThunderTime(int time) {
        this.field_76114_p = time;
    }

    @Override
    public GameMode getGameMode() {
        return (GameMode)this.field_76113_q;
    }

    @Override
    public void setGameMode(GameMode gamemode) {
        this.field_76113_q = GameModeRegistryModule.toGameType(gamemode);
    }

    @Override
    public boolean usesMapFeatures() {
        return this.field_76112_r;
    }

    @Override
    public void setMapFeaturesEnabled(boolean state) {
        this.field_76112_r = state;
    }

    @Override
    public boolean isHardcore() {
        return this.field_76111_s;
    }

    @Override
    public void setHardcore(boolean state) {
        this.field_76111_s = state;
    }

    @Override
    public boolean areCommandsAllowed() {
        return this.field_76110_t;
    }

    @Override
    public void setCommandsAllowed(boolean state) {
        this.field_76110_t = state;
    }

    @Override
    public boolean isInitialized() {
        return this.field_76109_u;
    }

    @Override
    public Difficulty getDifficulty() {
        return (Difficulty)this.field_176158_z;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.field_176158_z = (EnumDifficulty)difficulty;
    }

    @Override
    public boolean doesGenerateBonusChest() {
        return this.generateBonusChest;
    }

    public void setDoesGenerateBonusChest(boolean state) {
        this.generateBonusChest = state;
    }

    @Override
    public Vector3d getWorldBorderCenter() {
        return new Vector3d(this.field_176151_B, 0.0, this.field_176152_C);
    }

    @Override
    public void setWorldBorderCenter(double x, double z) {
        this.field_176151_B = x;
        this.field_176152_C = z;
    }

    @Override
    public double getWorldBorderDiameter() {
        return this.field_176146_D;
    }

    @Override
    public void setWorldBorderDiameter(double diameter) {
        this.field_176146_D = diameter;
    }

    @Override
    public double getWorldBorderTargetDiameter() {
        return this.field_176148_F;
    }

    @Override
    public void setWorldBorderTargetDiameter(double diameter) {
        this.field_176148_F = diameter;
    }

    @Override
    public double getWorldBorderDamageThreshold() {
        return this.field_176149_G;
    }

    @Override
    public void setWorldBorderDamageThreshold(double distance) {
        this.field_176149_G = distance;
    }

    @Override
    public double getWorldBorderDamageAmount() {
        return this.field_176153_H;
    }

    @Override
    public void setWorldBorderDamageAmount(double damage) {
        this.field_176153_H = damage;
    }

    @Override
    public int getWorldBorderWarningTime() {
        return this.field_176155_J;
    }

    @Override
    public void setWorldBorderWarningTime(int time) {
        this.field_176155_J = time;
    }

    @Override
    public int getWorldBorderWarningDistance() {
        return this.field_176154_I;
    }

    @Override
    public void setWorldBorderWarningDistance(int distance) {
        this.field_176154_I = distance;
    }

    @Override
    public long getWorldBorderTimeRemaining() {
        return this.field_176147_E;
    }

    @Override
    public void setWorldBorderTimeRemaining(long time) {
        this.field_176147_E = time;
    }

    @Override
    public Optional<String> getGameRule(String gameRule) {
        Preconditions.checkNotNull((Object)gameRule, (Object)"The gamerule cannot be null!");
        if (this.field_82577_x.func_82765_e(gameRule)) {
            return Optional.of(this.field_82577_x.func_82767_a(gameRule));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, String> getGameRules() {
        ImmutableMap.Builder ruleMap = ImmutableMap.builder();
        for (String rule : this.field_82577_x.func_82763_b()) {
            ruleMap.put((Object)rule, (Object)this.field_82577_x.func_82767_a(rule));
        }
        return ruleMap.build();
    }

    @Override
    public void setGameRule(String gameRule, String value) {
        Preconditions.checkNotNull((Object)gameRule, (Object)"The gamerule cannot be null!");
        Preconditions.checkNotNull((Object)value, (Object)"The gamerule value cannot be null!");
        this.field_82577_x.func_82764_b(gameRule, value);
    }

    @Override
    public boolean removeGameRule(String gameRule) {
        Preconditions.checkNotNull((Object)gameRule, (Object)"The gamerule cannot be null!");
        return ((IMixinGameRules)this.field_82577_x).removeGameRule(gameRule);
    }

    @Override
    public void setDimensionId(int id) {
        this.dimensionId = id;
    }

    @Override
    public Integer getDimensionId() {
        return this.dimensionId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public int getContentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        return NbtTranslator.getInstance().translateFrom(this.func_76082_a(null));
    }

    @Override
    public boolean isEnabled() {
        if (!this.getOrCreateWorldConfig().getConfig().isConfigEnabled()) {
            return ((ConfigBase)SpongeHooks.getActiveConfig(((IMixinDimensionType)((Object)this.dimensionType)).getConfigPath(), this.getWorldName()).getConfig()).getWorld().isWorldEnabled();
        }
        return this.getOrCreateWorldConfig().getConfig().getWorld().isWorldEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getOrCreateWorldConfig().getConfig().getWorld().setWorldEnabled(enabled);
    }

    @Override
    public boolean loadOnStartup() {
        DimensionConfig dimConfig;
        Boolean loadOnStartup = null;
        loadOnStartup = !this.getOrCreateWorldConfig().getConfig().isConfigEnabled() ? ((dimConfig = ((IMixinDimensionType)((Object)this.dimensionType)).getDimensionConfig().getConfig()).isConfigEnabled() ? dimConfig.getWorld().loadOnStartup() : this.getOrCreateWorldConfig().getConfig().getWorld().loadOnStartup()) : this.getOrCreateWorldConfig().getConfig().getWorld().loadOnStartup();
        if (loadOnStartup == null) {
            loadOnStartup = ((IMixinDimensionType)((Object)this.dimensionType)).shouldGenerateSpawnOnLoad();
            this.setLoadOnStartup(loadOnStartup);
        } else if (this.isMod && !loadOnStartup.booleanValue() && this.dimensionId.intValue() == ((net.minecraft.world.DimensionType)this.dimensionType).func_186068_a()) {
            loadOnStartup = ((IMixinDimensionType)((Object)this.dimensionType)).shouldGenerateSpawnOnLoad();
            this.setLoadOnStartup(loadOnStartup);
        }
        return loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(boolean state) {
        this.getOrCreateWorldConfig().getConfig().getWorld().setLoadOnStartup(state);
        if (!this.getOrCreateWorldConfig().getConfig().isConfigEnabled()) {
            this.getOrCreateWorldConfig().save();
        }
    }

    @Override
    public boolean doesKeepSpawnLoaded() {
        DimensionConfig dimConfig;
        Boolean keepSpawnLoaded = null;
        keepSpawnLoaded = !this.getOrCreateWorldConfig().getConfig().isConfigEnabled() ? ((dimConfig = ((IMixinDimensionType)((Object)this.dimensionType)).getDimensionConfig().getConfig()).isConfigEnabled() ? dimConfig.getWorld().getKeepSpawnLoaded() : this.getOrCreateWorldConfig().getConfig().getWorld().getKeepSpawnLoaded()) : this.getOrCreateWorldConfig().getConfig().getWorld().getKeepSpawnLoaded();
        if (keepSpawnLoaded == null) {
            keepSpawnLoaded = ((IMixinDimensionType)((Object)this.dimensionType)).shouldGenerateSpawnOnLoad();
            this.setKeepSpawnLoaded(keepSpawnLoaded);
        }
        return keepSpawnLoaded;
    }

    @Override
    public void setKeepSpawnLoaded(boolean loaded) {
        this.getOrCreateWorldConfig().getConfig().getWorld().setKeepSpawnLoaded(loaded);
        if (!this.getOrCreateWorldConfig().getConfig().isConfigEnabled()) {
            this.getOrCreateWorldConfig().save();
        }
    }

    @Override
    public boolean doesGenerateSpawnOnLoad() {
        DimensionConfig dimConfig;
        Boolean shouldGenerateSpawn = null;
        shouldGenerateSpawn = !this.getOrCreateWorldConfig().getConfig().isConfigEnabled() ? ((dimConfig = ((IMixinDimensionType)((Object)this.dimensionType)).getDimensionConfig().getConfig()).isConfigEnabled() ? dimConfig.getWorld().getGenerateSpawnOnLoad() : this.getOrCreateWorldConfig().getConfig().getWorld().getGenerateSpawnOnLoad()) : this.getOrCreateWorldConfig().getConfig().getWorld().getGenerateSpawnOnLoad();
        if (shouldGenerateSpawn == null) {
            shouldGenerateSpawn = ((IMixinDimensionType)((Object)this.dimensionType)).shouldGenerateSpawnOnLoad();
            this.setGenerateSpawnOnLoad(shouldGenerateSpawn);
        }
        return shouldGenerateSpawn;
    }

    @Override
    public void setGenerateSpawnOnLoad(boolean state) {
        this.getOrCreateWorldConfig().getConfig().getWorld().setGenerateSpawnOnLoad(state);
        if (!this.getOrCreateWorldConfig().getConfig().isConfigEnabled()) {
            this.getOrCreateWorldConfig().save();
        }
    }

    @Override
    public boolean isPVPEnabled() {
        return !this.getOrCreateWorldConfig().getConfig().isConfigEnabled() || this.getOrCreateWorldConfig().getConfig().getWorld().getPVPEnabled();
    }

    @Override
    public void setPVPEnabled(boolean enabled) {
        this.getOrCreateWorldConfig().getConfig().getWorld().setPVPEnabled(enabled);
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.uuid = uniqueId;
    }

    @Override
    public void setIsMod(boolean flag) {
        this.isMod = flag;
    }

    @Override
    public void setScoreboard(ServerScoreboard scoreboard) {
        this.scoreboard = scoreboard;
    }

    @Override
    public boolean getIsMod() {
        return this.isMod;
    }

    @Override
    public SpongeConfig<WorldConfig> getOrCreateWorldConfig() {
        if (this.worldConfig == null) {
            this.createWorldConfig();
        }
        return this.worldConfig;
    }

    @Override
    public SpongeConfig<WorldConfig> getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public Collection<WorldGeneratorModifier> getGeneratorModifiers() {
        return WorldGeneratorModifierRegistryModule.getInstance().toModifiers(this.getOrCreateWorldConfig().getConfig().getWorldGenModifiers());
    }

    @Override
    public void setGeneratorModifiers(Collection<WorldGeneratorModifier> modifiers) {
        Preconditions.checkNotNull(modifiers, (Object)"modifiers");
        this.getOrCreateWorldConfig().getConfig().getWorldGenModifiers().clear();
        this.getOrCreateWorldConfig().getConfig().getWorldGenModifiers().addAll((Collection<String>)WorldGeneratorModifierRegistryModule.getInstance().toIds(modifiers));
    }

    @Override
    public DataContainer getGeneratorSettings() {
        try {
            return DataFormats.JSON.read(this.field_82576_c);
        }
        catch (JsonParseException | IOException throwable) {
            return DataContainer.createNew().set(DataQueries.WORLD_CUSTOM_SETTINGS, (Object)this.field_82576_c);
        }
    }

    @Override
    public SerializationBehavior getSerializationBehavior() {
        return this.serializationBehavior;
    }

    @Override
    public void setSerializationBehavior(SerializationBehavior behavior) {
        this.serializationBehavior = behavior;
    }

    @Override
    public Optional<DataView> getPropertySection(DataQuery path) {
        if (this.spongeRootLevelNbt.func_74764_b(path.toString())) {
            return Optional.of(NbtTranslator.getInstance().translateFrom(this.spongeRootLevelNbt.func_74775_l(path.toString())));
        }
        return Optional.empty();
    }

    @Override
    public void setPropertySection(DataQuery path, DataView data) {
        NBTTagCompound nbt = NbtTranslator.getInstance().translateData(data);
        this.spongeRootLevelNbt.func_74782_a(path.toString(), (NBTBase)nbt);
    }

    @Override
    public int getIndexForUniqueId(UUID uuid) {
        Integer index = (Integer)this.playerUniqueIdMap.inverse().get((Object)uuid);
        if (index != null) {
            return index;
        }
        this.playerUniqueIdMap.put((Object)this.trackedUniqueIdCount, (Object)uuid);
        this.pendingUniqueIds.add(uuid);
        return this.trackedUniqueIdCount++;
    }

    @Override
    public Optional<UUID> getUniqueIdForIndex(int index) {
        return Optional.ofNullable(this.playerUniqueIdMap.get((Object)index));
    }

    @Override
    public NBTTagCompound getSpongeRootLevelNbt() {
        this.writeSpongeNbt();
        return this.spongeRootLevelNbt;
    }

    @Override
    public NBTTagCompound getSpongeNbt() {
        this.writeSpongeNbt();
        return this.spongeNbt;
    }

    @Override
    public void setSpongeRootLevelNBT(NBTTagCompound nbt) {
        this.spongeRootLevelNbt = nbt;
        if (nbt.func_74764_b("SpongeData")) {
            this.spongeNbt = nbt.func_74775_l("SpongeData");
        }
    }

    @Override
    public void readSpongeNbt(NBTTagCompound nbt) {
        UUID nbtUniqueId = nbt.func_186857_a("UUID");
        if (nbtUniqueId.equals(UUID.fromString("00000000-0000-0000-0000-000000000000"))) {
            return;
        }
        this.uuid = nbtUniqueId;
        this.dimensionId = nbt.func_74762_e("dimensionId");
        String dimensionTypeId = nbt.func_74779_i("dimensionType");
        DimensionType dimensionType = WorldManager.getDimensionType(this.dimensionId).orElse(null);
        this.setDimensionType(dimensionType != null ? dimensionType : DimensionTypeRegistryModule.getInstance().getById(dimensionTypeId).orElseThrow(FunctionalUtil.invalidArgument("Could not find a DimensionType registered for world '" + this.getWorldName() + "' with dim id: " + this.dimensionId)));
        this.generateBonusChest = nbt.func_74767_n("GenerateBonusChest");
        this.portalAgentType = PortalAgentRegistryModule.getInstance().validatePortalAgent(nbt.func_74779_i("portalAgentType"), this.field_76106_k);
        this.trackedUniqueIdCount = 0;
        if (nbt.func_74764_b("serializationBehavior")) {
            short saveBehavior = nbt.func_74765_d("serializationBehavior");
            this.serializationBehavior = saveBehavior == 1 ? SerializationBehaviors.AUTOMATIC : (saveBehavior == 0 ? SerializationBehaviors.MANUAL : SerializationBehaviors.NONE);
        }
        if (nbt.func_150297_b("PlayerIdTable", 9)) {
            NBTTagList playerIdList = nbt.func_150295_c("PlayerIdTable", 10);
            for (int i = 0; i < playerIdList.func_74745_c(); ++i) {
                NBTTagCompound playerId = playerIdList.func_150305_b(i);
                UUID playerUuid = playerId.func_186857_a("UUID");
                Integer playerIndex = (Integer)this.playerUniqueIdMap.inverse().get((Object)playerUuid);
                if (playerIndex == null) {
                    this.playerUniqueIdMap.put((Object)this.trackedUniqueIdCount++, (Object)playerUuid);
                    continue;
                }
                playerIdList.func_74744_a(i);
            }
        }
    }

    private void writeSpongeNbt() {
        if (this.uuid != null) {
            this.spongeNbt.func_74768_a("DataVersion", 1);
            this.spongeNbt.func_186854_a("UUID", this.uuid);
            this.spongeNbt.func_74768_a("dimensionId", this.dimensionId.intValue());
            this.spongeNbt.func_74778_a("dimensionType", this.dimensionType.getId());
            this.spongeNbt.func_74757_a("GenerateBonusChest", this.generateBonusChest);
            if (this.portalAgentType == null) {
                this.portalAgentType = PortalAgentTypes.DEFAULT;
            }
            this.spongeNbt.func_74778_a("portalAgentType", this.portalAgentType.getPortalAgentClass().getName());
            short saveBehavior = 1;
            if (this.serializationBehavior == SerializationBehaviors.NONE) {
                saveBehavior = -1;
            } else if (this.serializationBehavior == SerializationBehaviors.MANUAL) {
                saveBehavior = 0;
            }
            this.spongeNbt.func_74777_a("serializationBehavior", saveBehavior);
            Iterator<UUID> iterator = this.pendingUniqueIds.iterator();
            NBTTagList playerIdList = this.spongeNbt.func_150295_c("PlayerIdTable", 10);
            while (iterator.hasNext()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_186854_a("UUID", iterator.next());
                playerIdList.func_74742_a((NBTBase)compound);
                iterator.remove();
            }
        }
    }

    @Override
    public DataContainer getAdditionalProperties() {
        NBTTagCompound additionalProperties = this.spongeRootLevelNbt.func_74737_b();
        additionalProperties.func_82580_o("Sponge");
        return NbtTranslator.getInstance().translateFrom(additionalProperties);
    }
}

