/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network;

import com.flowpowered.math.vector.Vector3d;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.entity.living.humanoid.AnimateHandEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.packet.IPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public class PacketUtil {
    private static final PhaseContext EMPTY_INVALID = PhaseContext.start().complete();
    private static long lastInventoryOpenPacketTimeStamp = 0L;
    private static long lastTryBlockPacketTimeStamp = 0L;
    private static boolean lastTryBlockPacketItemResult = true;

    public static void onProcessPacket(Packet packetIn, INetHandler netHandler) {
        if (netHandler instanceof NetHandlerPlayServer) {
            long packetDiff;
            EntityPlayerMP packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
            if (PacketUtil.firePreEvents(packetIn, packetPlayer)) {
                return;
            }
            boolean ignoreCreative = false;
            if (packetPlayer.field_71134_c.func_73083_d() && packetIn instanceof CPacketClientStatus && ((CPacketClientStatus)packetIn).func_149435_c() == CPacketClientStatus.State.OPEN_INVENTORY_ACHIEVEMENT) {
                lastInventoryOpenPacketTimeStamp = System.currentTimeMillis();
            } else if (PacketUtil.creativeCheck(packetIn, packetPlayer) && (packetDiff = System.currentTimeMillis() - lastInventoryOpenPacketTimeStamp) < 100L) {
                ignoreCreative = true;
            }
            boolean ignoreMovementCapture = false;
            if (packetIn instanceof CPacketPlayer) {
                CPacketPlayer movingPacket = (CPacketPlayer)packetIn;
                if (movingPacket instanceof CPacketPlayer.Rotation) {
                    ignoreMovementCapture = true;
                } else if (packetPlayer.field_70165_t == movingPacket.field_149479_a && packetPlayer.field_70163_u == movingPacket.field_149477_b && packetPlayer.field_70161_v == movingPacket.field_149478_c) {
                    ignoreMovementCapture = true;
                }
            }
            if (!CauseTracker.ENABLED || ignoreMovementCapture || packetIn instanceof CPacketClientSettings) {
                packetIn.func_148833_a(netHandler);
            } else {
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(packetPlayer.field_71071_by.func_70445_o());
                CauseTracker causeTracker = CauseTracker.getInstance();
                IPacketState packetState = TrackingPhases.PACKET.getStateForPacket(packetIn);
                if (packetState == null) {
                    throw new IllegalArgumentException("Found a null packet phase for packet: " + packetIn.getClass());
                }
                PhaseContext context = EMPTY_INVALID;
                if (!TrackingPhases.PACKET.isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    context = PhaseContext.start().add(NamedCause.source(packetPlayer)).add(NamedCause.of("PacketPlayer", packetPlayer)).add(NamedCause.of("Packet", packetIn)).add(NamedCause.of("Cursor", cursor)).add(NamedCause.of("IgnoringCreative", ignoreCreative));
                    TrackingPhases.PACKET.populateContext(packetIn, packetPlayer, packetState, context);
                    context.owner((Player)packetPlayer);
                    context.notifier((Player)packetPlayer);
                    context.complete();
                } else {
                    packetState = PacketPhase.General.INVALID;
                }
                causeTracker.switchToPhase(packetState, context, () -> {
                    packetIn.func_148833_a(netHandler);
                    return null;
                });
                if (packetIn instanceof CPacketClientStatus) {
                    packetPlayer = ((NetHandlerPlayServer)netHandler).field_147369_b;
                }
                ((IMixinEntityPlayerMP)packetPlayer).setPacketItem(null);
            }
        } else {
            packetIn.func_148833_a(netHandler);
        }
    }

    private static boolean creativeCheck(Packet<?> packetIn, EntityPlayerMP playerMP) {
        return packetIn instanceof CPacketCreativeInventoryAction;
    }

    private static boolean firePreEvents(Packet<?> packetIn, EntityPlayerMP playerMP) {
        if (packetIn instanceof CPacketAnimation) {
            CPacketAnimation packet = (CPacketAnimation)packetIn;
            SpongeCommonEventFactory.lastAnimationPacketTick = SpongeImpl.getServer().func_71259_af();
            SpongeCommonEventFactory.lastAnimationPlayer = new WeakReference<EntityPlayerMP>(playerMP);
            HandType handType = packet.func_187018_a() == EnumHand.MAIN_HAND ? HandTypes.MAIN_HAND : HandTypes.OFF_HAND;
            AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(Cause.of(NamedCause.source(playerMP)), handType, (Humanoid)playerMP);
            return SpongeImpl.postEvent(event);
        }
        if (packetIn instanceof CPacketPlayerDigging) {
            SpongeCommonEventFactory.lastPrimaryPacketTick = SpongeImpl.getServer().func_71259_af();
            CPacketPlayerDigging packet = (CPacketPlayerDigging)packetIn;
            ItemStack stack = playerMP.func_184614_ca();
            switch (packet.func_180762_c()) {
                case DROP_ITEM: 
                case DROP_ALL_ITEMS: {
                    if (!stack.func_190926_b() && !playerMP.func_175149_v()) {
                        ((IMixinEntityPlayerMP)playerMP).setPacketItem(stack.func_77946_l());
                    }
                    return false;
                }
                case START_DESTROY_BLOCK: 
                case ABORT_DESTROY_BLOCK: 
                case STOP_DESTROY_BLOCK: {
                    BlockPos pos = packet.func_179715_a();
                    Vector3d interactionPoint = VecHelper.toVector3d(pos);
                    BlockSnapshot blockSnapshot = new Location<World>((World)playerMP.field_70170_p, interactionPoint).createSnapshot();
                    if (SpongeCommonEventFactory.callInteractItemEventPrimary((EntityPlayer)playerMP, stack, EnumHand.MAIN_HAND, Optional.of(interactionPoint), blockSnapshot).isCancelled()) {
                        ((IMixinEntityPlayerMP)playerMP).sendBlockChange(pos, playerMP.field_70170_p.func_180495_p(pos));
                        return true;
                    }
                    double d0 = playerMP.field_70165_t - ((double)pos.func_177958_n() + 0.5);
                    double d1 = playerMP.field_70163_u - ((double)pos.func_177956_o() + 0.5) + 1.5;
                    double d2 = playerMP.field_70161_v - ((double)pos.func_177952_p() + 0.5);
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    double dist = SpongeImplHooks.getBlockReachDistance(playerMP) + 1.0;
                    if (d3 > (dist *= dist)) {
                        return true;
                    }
                    if (pos.func_177956_o() >= SpongeImpl.getServer().func_71207_Z()) {
                        return true;
                    }
                    if (packet.func_180762_c() == CPacketPlayerDigging.Action.START_DESTROY_BLOCK && SpongeCommonEventFactory.callInteractBlockEventPrimary((EntityPlayer)playerMP, blockSnapshot, EnumHand.MAIN_HAND, packet.func_179714_b()).isCancelled()) {
                        ((IMixinEntityPlayerMP)playerMP).sendBlockChange(pos, playerMP.field_70170_p.func_180495_p(pos));
                        return true;
                    }
                    return false;
                }
            }
        } else if (packetIn instanceof CPacketPlayerTryUseItem) {
            CPacketPlayerTryUseItem packet = (CPacketPlayerTryUseItem)packetIn;
            SpongeCommonEventFactory.lastSecondaryPacketTick = SpongeImpl.getServer().func_71259_af();
            long packetDiff = System.currentTimeMillis() - lastTryBlockPacketTimeStamp;
            if (packetDiff < 100L) {
                return lastTryBlockPacketItemResult;
            }
            boolean isCancelled = SpongeCommonEventFactory.callInteractItemEventSecondary((EntityPlayer)playerMP, playerMP.func_184586_b(packet.func_187028_a()), packet.func_187028_a(), Optional.empty(), BlockSnapshot.NONE).isCancelled();
            SpongeCommonEventFactory.callInteractBlockEventSecondary(Cause.of(NamedCause.source(playerMP)), Optional.empty(), BlockSnapshot.NONE, Direction.NONE, packet.func_187028_a());
            if (isCancelled) {
                playerMP.func_71110_a(playerMP.field_71070_bA, playerMP.field_71070_bA.func_75138_a());
                return true;
            }
        } else if (packetIn instanceof CPacketPlayerTryUseItemOnBlock) {
            boolean isCancelled;
            CPacketPlayerTryUseItemOnBlock packet = (CPacketPlayerTryUseItemOnBlock)packetIn;
            lastTryBlockPacketTimeStamp = System.currentTimeMillis();
            SpongeCommonEventFactory.lastSecondaryPacketTick = SpongeImpl.getServer().func_71259_af();
            Vector3d interactionPoint = VecHelper.toVector3d(packet.func_187023_a());
            BlockSnapshot blockSnapshot = new Location<World>((World)playerMP.field_70170_p, interactionPoint).createSnapshot();
            lastTryBlockPacketItemResult = isCancelled = SpongeCommonEventFactory.callInteractItemEventSecondary((EntityPlayer)playerMP, playerMP.func_184586_b(packet.func_187022_c()), packet.func_187022_c(), Optional.of(interactionPoint), blockSnapshot).isCancelled();
            if (isCancelled) {
                BlockPos pos = packet.func_187023_a();
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(playerMP.field_70170_p, pos));
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(playerMP.field_70170_p, pos.func_177972_a(packet.func_187024_b())));
                playerMP.func_71110_a(playerMP.field_71070_bA, playerMP.field_71070_bA.func_75138_a());
                return true;
            }
        }
        return false;
    }
}

