/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.profile.ProfileNotFoundException;
import org.spongepowered.common.util.SpongeUsernameCache;

public abstract class Query<V>
implements Callable<V> {
    protected GameProfileCache cache;
    protected final boolean useCache;

    public Query(GameProfileCache cache, boolean useCache) {
        this.cache = cache;
        this.useCache = useCache;
    }

    protected List<GameProfile> fromUniqueIds(Collection<UUID> uniqueIds) throws ProfileNotFoundException {
        if (this.useCache) {
            ArrayList pool = Lists.newArrayList(uniqueIds);
            ArrayList result = Lists.newArrayListWithCapacity((int)uniqueIds.size());
            Iterator it = pool.iterator();
            while (it.hasNext()) {
                UUID uniqueId = (UUID)it.next();
                String username = SpongeUsernameCache.getLastKnownUsername(uniqueId);
                if (username == null) continue;
                result.add(GameProfile.of(uniqueId, username));
                it.remove();
            }
            if (!pool.isEmpty()) {
                result.addAll(this.cache.getOrLookupByIds(pool).values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            }
            return result;
        }
        return this.cache.lookupByIds(uniqueIds).values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected GameProfile fillProfile(GameProfile profile, boolean signed) throws ProfileNotFoundException {
        Optional<GameProfile> result;
        if (this.useCache && (result = this.cache.getById(profile.getUniqueId())).isPresent() && result.get().isFilled() && !result.get().getPropertyMap().isEmpty()) {
            return result.get();
        }
        result = this.cache.fillProfile(profile, signed);
        if (result.isPresent() && result.get().isFilled()) {
            GameProfile t = result.get();
            this.cache.add(t, true, null);
            return t;
        }
        throw new ProfileNotFoundException("Profile: " + profile);
    }

    protected List<GameProfile> fromNames(Collection<String> names) throws ProfileNotFoundException {
        if (this.useCache) {
            return this.cache.getOrLookupByNames(names).values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return this.cache.lookupByNames(names).values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

