/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.spongepowered.common.SpongeImpl;

public class RegistryHelper {
    public static boolean mapFields(Class<?> apiClass, Map<String, ?> mapping) {
        return RegistryHelper.mapFields(apiClass, mapping, null);
    }

    public static boolean mapFields(Class<?> apiClass, Map<String, ?> mapping, Set<String> ignoredFields) {
        return RegistryHelper.mapFields(apiClass, fieldName -> mapping.get(fieldName.toLowerCase(Locale.ENGLISH)), ignoredFields, false);
    }

    public static boolean mapFieldsIgnoreWarning(Class<?> apiClass, Map<String, ?> mapping) {
        return RegistryHelper.mapFields(apiClass, fieldname -> mapping.get(fieldname.toLowerCase(Locale.ENGLISH)), null, true);
    }

    public static boolean mapFields(Class<?> apiClass, Function<String, ?> mapFunction) {
        return RegistryHelper.mapFields(apiClass, mapFunction, null, false);
    }

    public static boolean mapFields(Class<?> apiClass, Function<String, ?> mapFunction, Set<String> ignoredFields) {
        return RegistryHelper.mapFields(apiClass, mapFunction, ignoredFields, false);
    }

    public static boolean mapFields(Class<?> apiClass, Function<String, ?> mapFunction, Set<String> ignoredFields, boolean ignore) {
        boolean mappingSuccess = true;
        for (Field f : apiClass.getDeclaredFields()) {
            String fieldName = f.getName();
            if (ignoredFields != null && ignoredFields.contains(fieldName)) continue;
            try {
                Object value = mapFunction.apply(fieldName);
                if (value == null) {
                    value = mapFunction.apply("minecraft:" + fieldName);
                }
                if (value == null && !ignore) {
                    SpongeImpl.getLogger().warn("Skipping {}.{}", new Object[]{f.getDeclaringClass().getName(), fieldName});
                    continue;
                }
                f.set(null, value);
            }
            catch (Exception e) {
                if (!ignore) {
                    SpongeImpl.getLogger().error("Error while mapping {}.{}", new Object[]{f.getDeclaringClass().getName(), fieldName, e});
                }
                mappingSuccess = false;
            }
        }
        return mappingSuccess;
    }

    public static boolean setFactory(Class<?> apiClass, Object factory) {
        try {
            apiClass.getDeclaredField("factory").set(null, factory);
            return true;
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Error while setting factory on {}", new Object[]{apiClass, e});
            return false;
        }
    }

    public static void setFinalStatic(Class<?> clazz, String fieldName, Object newValue) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Field modifiers = field.getClass().getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, newValue);
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Error while setting field {}.{}", new Object[]{clazz.getName(), fieldName, e});
        }
    }
}

