/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.EnumDyeColor;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class DyeColorRegistryModule
implements CatalogRegistryModule<DyeColor> {
    @RegisterCatalog(value=DyeColors.class)
    private final Map<String, DyeColor> dyeColorMappings = Maps.newHashMap();

    public static DyeColorRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<DyeColor> getById(String id) {
        return Optional.ofNullable(this.dyeColorMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<DyeColor> getAll() {
        return ImmutableList.copyOf(this.dyeColorMappings.values());
    }

    @Override
    public void registerDefaults() {
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            this.dyeColorMappings.put(dyeColor.func_176610_l().toLowerCase(Locale.ENGLISH), (DyeColor)dyeColor);
        }
    }

    @AdditionalRegistration
    public void registerAdditional() {
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            if (this.dyeColorMappings.containsValue((DyeColor)dyeColor)) continue;
            this.dyeColorMappings.put(dyeColor.func_176610_l().toLowerCase(Locale.ENGLISH), (DyeColor)dyeColor);
        }
    }

    public static Optional<DyeColor> fromId(int id) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            if (color.func_176767_b() != id) continue;
            return Optional.of((DyeColor)color);
        }
        return Optional.empty();
    }

    DyeColorRegistryModule() {
    }

    private static final class Holder {
        static final DyeColorRegistryModule INSTANCE = new DyeColorRegistryModule();

        private Holder() {
        }
    }
}

