/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BooleanTrait;
import org.spongepowered.api.block.trait.BooleanTraits;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=BooleanTraits.class)
public final class BooleanTraitRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<BooleanTrait>
implements SpongeAdditionalCatalogRegistryModule<BooleanTrait> {
    public static BooleanTraitRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(BooleanTrait extraCatalog) {
        this.catalogTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    public void registerBlock(String id, BlockType block, BooleanTrait property) {
        Preconditions.checkNotNull((Object)id, (Object)"Id was null!");
        Preconditions.checkNotNull((Object)property, (Object)"Property was null!");
        this.catalogTypeMap.put(id.toLowerCase(Locale.ENGLISH), property);
        String propertyId = block.getId().toLowerCase(Locale.ENGLISH) + "_" + property.getName().toLowerCase(Locale.ENGLISH);
        this.catalogTypeMap.put(propertyId, property);
    }

    BooleanTraitRegistryModule() {
        super("minecraft", new String[]{"minecraft:"});
    }

    private static final class Holder {
        static final BooleanTraitRegistryModule INSTANCE = new BooleanTraitRegistryModule();

        private Holder() {
        }
    }
}

