/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.RabbitType;
import org.spongepowered.api.data.type.RabbitTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeEntityConstants;

public class RabbitTypeRegistryModule
implements CatalogRegistryModule<RabbitType> {
    @RegisterCatalog(value=RabbitTypes.class)
    private final Map<String, RabbitType> rabbitTypeMap = new HashMap<String, RabbitType>();

    @Override
    public Optional<RabbitType> getById(String id) {
        return Optional.ofNullable(this.rabbitTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<RabbitType> getAll() {
        return ImmutableList.copyOf(this.rabbitTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.rabbitTypeMap.putAll(SpongeEntityConstants.RABBIT_TYPES);
    }
}

