/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.SkeletonType;
import org.spongepowered.api.data.type.SkeletonTypes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.entity.SpongeSkeletonType;

public class SkeletonTypeRegistryModule
implements CatalogRegistryModule<SkeletonType> {
    @RegisterCatalog(value=SkeletonTypes.class)
    private final Map<String, SkeletonType> skeletonTypeMap = new HashMap<String, SkeletonType>();

    @Override
    public Optional<SkeletonType> getById(String id) {
        return Optional.ofNullable(this.skeletonTypeMap.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<SkeletonType> getAll() {
        return ImmutableList.copyOf(this.skeletonTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.skeletonTypeMap.put("normal", new SpongeSkeletonType("normal"));
        this.skeletonTypeMap.put("stray", new SpongeSkeletonType("stray"));
        this.skeletonTypeMap.put("wither", new SpongeSkeletonType("wither"));
    }
}

