/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.type.ZombieType;
import org.spongepowered.api.data.type.ZombieTypes;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.data.type.SpongeZombieType;

public class ZombieTypeRegistryModule
implements AlternateCatalogRegistryModule<ZombieType> {
    @RegisterCatalog(value=ZombieTypes.class)
    public final Map<String, ZombieType> types = Maps.newHashMap();

    public static ZombieTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        this.types.put("minecraft:normal", new SpongeZombieType("minecraft:normal", "Zombie"));
        this.types.put("minecraft:villager", new SpongeZombieType("minecraft:villager", "ZombieVillager"));
        this.types.put("minecraft:husk", new SpongeZombieType("minecraft:husk", "Husk"));
    }

    @Override
    public Optional<ZombieType> getById(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.types.get(id));
    }

    @Override
    public Collection<ZombieType> getAll() {
        return ImmutableSet.copyOf(this.types.values());
    }

    private ZombieTypeRegistryModule() {
    }

    @Override
    public Map<String, ZombieType> provideCatalogMap() {
        HashMap<String, ZombieType> map = new HashMap<String, ZombieType>();
        for (Map.Entry<String, ZombieType> entry : this.types.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return map;
    }

    static final class Holder {
        static final ZombieTypeRegistryModule INSTANCE = new ZombieTypeRegistryModule();

        Holder() {
        }
    }
}

