/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

public class SpawnTypeRegistryModule
implements AlternateCatalogRegistryModule<SpawnType>,
AdditionalCatalogRegistryModule<SpawnType> {
    @RegisterCatalog(value=SpawnTypes.class)
    private final Map<String, SpawnType> spawnTypeMap = new HashMap<String, SpawnType>();

    @Override
    public void registerAdditionalCatalog(SpawnType extraCatalog) {
        Preconditions.checkArgument((!this.spawnTypeMap.containsKey(extraCatalog.getId().toLowerCase(Locale.ENGLISH)) ? 1 : 0) != 0, (String)"SpawnType with the same id is already registered: {}", (Object[])new Object[]{extraCatalog.getId()});
        this.spawnTypeMap.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public Optional<SpawnType> getById(String id) {
        String key = ((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH);
        if (!key.contains(":")) {
            key = "sponge:" + key;
        }
        return Optional.ofNullable(this.spawnTypeMap.get(key));
    }

    @Override
    public Collection<SpawnType> getAll() {
        return ImmutableSet.copyOf(this.spawnTypeMap.values());
    }

    @Override
    public void registerDefaults() {
        this.spawnTypeMap.put("sponge:block_spawning", InternalSpawnTypes.BLOCK_SPAWNING);
        this.spawnTypeMap.put("sponge:breeding", InternalSpawnTypes.BREEDING);
        this.spawnTypeMap.put("sponge:dispense", InternalSpawnTypes.DISPENSE);
        this.spawnTypeMap.put("sponge:dropped_item", InternalSpawnTypes.DROPPED_ITEM);
        this.spawnTypeMap.put("sponge:experience", InternalSpawnTypes.EXPERIENCE);
        this.spawnTypeMap.put("sponge:falling_block", InternalSpawnTypes.FALLING_BLOCK);
        this.spawnTypeMap.put("sponge:mob_spawner", InternalSpawnTypes.MOB_SPAWNER);
        this.spawnTypeMap.put("sponge:passive", InternalSpawnTypes.PASSIVE);
        this.spawnTypeMap.put("sponge:placement", InternalSpawnTypes.PLACEMENT);
        this.spawnTypeMap.put("sponge:projectile", InternalSpawnTypes.PROJECTILE);
        this.spawnTypeMap.put("sponge:spawn_egg", InternalSpawnTypes.SPAWN_EGG);
        this.spawnTypeMap.put("sponge:structure", InternalSpawnTypes.STRUCTURE);
        this.spawnTypeMap.put("sponge:tnt_ignite", InternalSpawnTypes.TNT_IGNITE);
        this.spawnTypeMap.put("sponge:weather", InternalSpawnTypes.WEATHER);
        this.spawnTypeMap.put("sponge:custom", InternalSpawnTypes.CUSTOM);
        this.spawnTypeMap.put("sponge:chunk_load", InternalSpawnTypes.CHUNK_LOAD);
        this.spawnTypeMap.put("sponge:world_spawner", InternalSpawnTypes.WORLD_SPAWNER);
        this.spawnTypeMap.put("sponge:plugin", InternalSpawnTypes.PLUGIN);
    }

    @Override
    public Map<String, SpawnType> provideCatalogMap() {
        HashMap<String, SpawnType> map = new HashMap<String, SpawnType>();
        for (Map.Entry<String, SpawnType> entry : this.spawnTypeMap.entrySet()) {
            map.put(entry.getKey().replace("sponge:", ""), entry.getValue());
        }
        return map;
    }
}

