/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.event.cause.entity.teleport.TeleportType;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.event.entity.teleport.SpongeTeleportType;

public final class TeleportTypeRegistryModule
implements AlternateCatalogRegistryModule<TeleportType>,
AdditionalCatalogRegistryModule<TeleportType> {
    @RegisterCatalog(value=TeleportTypes.class)
    private final Map<String, TeleportType> teleportTypeMappings = new HashMap<String, TeleportType>();

    public static TeleportTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Optional<TeleportType> getById(String id) {
        return Optional.ofNullable(this.teleportTypeMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<TeleportType> getAll() {
        return ImmutableList.copyOf(this.teleportTypeMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(TeleportType extraCatalog) {
        String id = ((TeleportType)Preconditions.checkNotNull((Object)extraCatalog)).getId();
        String key = id.toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!key.contains("sponge:") ? 1 : 0) != 0, (Object)"Cannot register spoofed teleport type!");
        Preconditions.checkArgument((!key.contains("minecraft:") ? 1 : 0) != 0, (Object)"Cannot register spoofed teleport type!");
        Preconditions.checkArgument((!this.teleportTypeMappings.containsKey(key) ? 1 : 0) != 0, (String)"Cannot register an already registered TeleportType: %s", (Object[])new Object[]{key});
        this.teleportTypeMappings.put(key, extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.teleportTypeMappings.put("minecraft:command", new SpongeTeleportType("minecraft:command", "Command"));
        this.teleportTypeMappings.put("minecraft:entity_teleport", new SpongeTeleportType("minecraft:entity_teleport", "Entity Teleport"));
        this.teleportTypeMappings.put("minecraft:portal", new SpongeTeleportType("minecraft:portal", "Portal"));
        this.teleportTypeMappings.put("sponge:plugin", new SpongeTeleportType("sponge:plugin", "Plugin"));
        this.teleportTypeMappings.put("sponge:unknown", new SpongeTeleportType("sponge:unknown", "Unknown"));
    }

    @Override
    public Map<String, TeleportType> provideCatalogMap() {
        HashMap<String, TeleportType> map = new HashMap<String, TeleportType>();
        for (Map.Entry<String, TeleportType> entry : this.teleportTypeMappings.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", "").replace("sponge:", ""), entry.getValue());
        }
        return map;
    }

    TeleportTypeRegistryModule() {
    }

    private static final class Holder {
        static final TeleportTypeRegistryModule INSTANCE = new TeleportTypeRegistryModule();

        private Holder() {
        }
    }
}

