/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.property.AcceptsItems;
import org.spongepowered.api.item.inventory.property.InventoryDimension;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.item.inventory.property.SlotIndex;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.item.inventory.SpongeInventoryBuilder;
import org.spongepowered.common.item.inventory.archetype.SlotArchetype;
import org.spongepowered.common.item.inventory.archetype.SpongeInventoryArchetypeBuilder;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class InventoryArchetypeRegistryModule
implements AlternateCatalogRegistryModule<InventoryArchetype>,
SpongeAdditionalCatalogRegistryModule<InventoryArchetype> {
    @RegisterCatalog(value=InventoryArchetypes.class)
    private final Map<String, InventoryArchetype> mapping = new HashMap<String, InventoryArchetype>();

    public static InventoryArchetypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, InventoryArchetype> provideCatalogMap() {
        HashMap<String, InventoryArchetype> map = new HashMap<String, InventoryArchetype>();
        map.putAll(this.mapping);
        for (Map.Entry<String, InventoryArchetype> entry : this.mapping.entrySet()) {
            map.put(entry.getKey().replace("minecraft:", "").replace("sponge:", ""), entry.getValue());
        }
        return map;
    }

    @Override
    public Optional<InventoryArchetype> getById(String id) {
        return Optional.ofNullable(this.mapping.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<InventoryArchetype> getAll() {
        return ImmutableList.copyOf(this.mapping.values());
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }

    @Override
    public void registerAdditionalCatalog(InventoryArchetype archetype) {
        Preconditions.checkNotNull((Object)archetype, (Object)"archetype");
        String id = archetype.getId();
        this.mapping.put(id.toLowerCase(Locale.ENGLISH), archetype);
    }

    @Override
    public void registerDefaults() {
        SlotArchetype SLOT = new SlotArchetype((Map<String, InventoryProperty<String, ?>>)ImmutableMap.of((Object)CustomInventory.INVENTORY_DIMENSION, (Object)new InventoryDimension(1, 1)));
        SpongeInventoryArchetypeBuilder builder = new SpongeInventoryArchetypeBuilder();
        for (int i = 0; i < 9; ++i) {
            builder.with(new SpongeInventoryArchetypeBuilder().from(SLOT).property(SlotIndex.of(i)).build("minecraft:slot" + i, "Slot"));
        }
        InventoryArchetype MENU_ROW = builder.property(new InventoryDimension(9, 1)).build("sponge:menu_row", "Menu Row");
        InventoryArchetype MENU_COLUMN = builder.property(new InventoryDimension(9, 1)).build("sponge:menu_column", "Menu Column");
        InventoryArchetype MENU_GRID = ((InventoryArchetype.Builder)builder.reset()).with(MENU_ROW).with(MENU_ROW).with(MENU_ROW).property(new InventoryDimension(9, 3)).build("sponge:menu_grid", "Menu Grid");
        InventoryArchetype CHEST = ((InventoryArchetype.Builder)builder.reset()).with(MENU_GRID).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.chest"), new Object[0]))).build("minecraft:chest", "Chest");
        InventoryArchetype DOUBLE_CHEST = ((InventoryArchetype.Builder)builder.reset()).with(CHEST).with(CHEST).property(new InventoryDimension(9, 6)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.chestDouble"), new Object[0]))).build("minecraft:double_chest", "DoubleChest");
        InventoryArchetype FURNACE = ((InventoryArchetype.Builder)builder.reset()).with(new SpongeInventoryArchetypeBuilder().from(SLOT).property(new SlotIndex(0)).build("minecraft:furnace_input", "FurnaceInput")).with(new SpongeInventoryArchetypeBuilder().from(SLOT).property(new SlotIndex(1)).property(AcceptsItems.of(new Object[0])).build("minecraft:furnace_fuel", "FurnaceFuel")).with(new SpongeInventoryArchetypeBuilder().from(SLOT).property(new SlotIndex(2)).property(AcceptsItems.of(new Object[0])).build("minecraft:furnace_output", "FurnaceOutput")).property(new InventoryTitle(Text.of(new SpongeTranslation("container.furnace"), new Object[0]))).property(new InventoryDimension(3, 1)).build("minecraft:furnace", "Furnace");
        InventoryArchetype DISPENSER = ((InventoryArchetype.Builder)builder.reset()).with(MENU_GRID).property(new InventoryDimension(3, 3)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.dispenser"), new Object[0]))).build("minecraft:dispenser", "Dispenser");
        InventoryArchetype WORKBENCH = ((InventoryArchetype.Builder)builder.reset()).with(new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property(new InventoryDimension(3, 3)).build("minecraft:workbench_grid", "Workbench Grid")).with((InventoryArchetype)SLOT).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.crafting"), new Object[0]))).build("minecraft:workbench", "Workbench");
        InventoryArchetype BREWING_STAND = ((InventoryArchetype.Builder)builder.reset()).with(MENU_ROW).property(new InventoryDimension(5, 1)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.brewing"), new Object[0]))).build("minecraft:brewing_stand", "BrewingStand");
        InventoryArchetype HOPPER = ((InventoryArchetype.Builder)builder.reset()).with(MENU_ROW).property(new InventoryDimension(5, 1)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.hopper"), new Object[0]))).build("minecraft:hopper", "Hopper");
        InventoryArchetype BEACON = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).property(new InventoryDimension(1, 1)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.beacon"), new Object[0]))).build("minecraft:beacon", "Beacon");
        InventoryArchetype ENCHANTING_TABLE = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property(new InventoryDimension(2, 1)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.enchant"), new Object[0]))).build("minecraft:enchanting_table", "EnchantingTable");
        InventoryArchetype ANVIL = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property(new InventoryDimension(3, 1)).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.repair"), new Object[0]))).build("minecraft:anvil", "Anvil");
        InventoryArchetype VILLAGER = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property(new InventoryDimension(3, 1)).build("minecraft:villager", "Villager");
        InventoryArchetype HORSE = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).with((InventoryArchetype)SLOT).property(new InventoryDimension(2, 1)).build("minecraft:horse", "Horse");
        InventoryArchetype HORSE_WITH_CHEST = ((InventoryArchetype.Builder)builder.reset()).with(HORSE).with(new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property(new InventoryDimension(5, 3)).build("horse_grid", "HorseGrid")).build("minecraft:horse_with_chest", "Horse with Chest");
        InventoryArchetype CRAFTING = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).with(new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property(new InventoryDimension(2, 2)).build("minecraft:crafting_grid", "Crafting Grid")).property(InventoryTitle.of(Text.of(new SpongeTranslation("container.crafting"), new Object[0]))).build("minecraft:crafting", "Crafting");
        InventoryArchetype PLAYER = ((InventoryArchetype.Builder)builder.reset()).with(CRAFTING).with(new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property(new InventoryDimension(1, 4)).build("minecraft:armor", "Armor")).with(new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property(new InventoryDimension(9, 3)).build("minecraft:player_main", "Player Main")).with(new SpongeInventoryArchetypeBuilder().from(MENU_GRID).property(new InventoryDimension(9, 1)).build("minecraft:player_hotbar", "Player Hotbar")).with(new SpongeInventoryArchetypeBuilder().from(SLOT).property(new InventoryDimension(1, 1)).build("minecraft:player_offhand", "Player Offhand")).build("minecraft:player", "Player");
        InventoryArchetype UNKNOWN = ((InventoryArchetype.Builder)builder.reset()).build("minecraft:unknown", "UKNOWN");
        this.registerAdditionalCatalog(SLOT);
        this.registerAdditionalCatalog(MENU_ROW);
        this.registerAdditionalCatalog(MENU_COLUMN);
        this.registerAdditionalCatalog(MENU_GRID);
        this.registerAdditionalCatalog(CHEST);
        SpongeInventoryBuilder.registerInventory(TileEntityChest.class, CHEST);
        SpongeInventoryBuilder.registerContainer(ContainerChest.class, CHEST);
        this.registerAdditionalCatalog(DOUBLE_CHEST);
        this.registerAdditionalCatalog(FURNACE);
        SpongeInventoryBuilder.registerInventory(TileEntityFurnace.class, FURNACE);
        SpongeInventoryBuilder.registerContainer(ContainerFurnace.class, FURNACE);
        this.registerAdditionalCatalog(DISPENSER);
        SpongeInventoryBuilder.registerInventory(TileEntityDispenser.class, DISPENSER);
        SpongeInventoryBuilder.registerInventory(TileEntityDropper.class, DISPENSER);
        SpongeInventoryBuilder.registerContainer(ContainerDispenser.class, DISPENSER);
        this.registerAdditionalCatalog(WORKBENCH);
        SpongeInventoryBuilder.registerContainer(ContainerWorkbench.class, WORKBENCH);
        this.registerAdditionalCatalog(BREWING_STAND);
        SpongeInventoryBuilder.registerInventory(TileEntityBrewingStand.class, BREWING_STAND);
        SpongeInventoryBuilder.registerContainer(ContainerBrewingStand.class, BREWING_STAND);
        this.registerAdditionalCatalog(HOPPER);
        SpongeInventoryBuilder.registerInventory(TileEntityHopper.class, HOPPER);
        SpongeInventoryBuilder.registerContainer(ContainerHopper.class, HOPPER);
        this.registerAdditionalCatalog(BEACON);
        SpongeInventoryBuilder.registerInventory(TileEntityBeacon.class, BEACON);
        SpongeInventoryBuilder.registerContainer(ContainerBeacon.class, BEACON);
        this.registerAdditionalCatalog(ENCHANTING_TABLE);
        SpongeInventoryBuilder.registerContainer(ContainerEnchantment.class, ENCHANTING_TABLE);
        this.registerAdditionalCatalog(ANVIL);
        SpongeInventoryBuilder.registerContainer(ContainerRepair.class, ANVIL);
        this.registerAdditionalCatalog(VILLAGER);
        SpongeInventoryBuilder.registerContainer(ContainerMerchant.class, VILLAGER);
        this.registerAdditionalCatalog(HORSE);
        SpongeInventoryBuilder.registerContainer(ContainerHorseInventory.class, HORSE);
        this.registerAdditionalCatalog(HORSE_WITH_CHEST);
        this.registerAdditionalCatalog(CRAFTING);
        this.registerAdditionalCatalog(PLAYER);
        this.registerAdditionalCatalog(UNKNOWN);
        InventoryArchetype MENU_ICON = ((InventoryArchetype.Builder)builder.reset()).with((InventoryArchetype)SLOT).build("sponge:menu_icon", "Menu Icon");
        InventoryArchetype MENU_BUTTON = ((InventoryArchetype.Builder)builder.reset()).with(MENU_ICON).build("sponge:menu_button", "Menu Button");
        InventoryArchetype MENU_CHECKBOX = ((InventoryArchetype.Builder)builder.reset()).with(MENU_ICON).build("sponge:menu_checkbox", "Menu Checkbox");
        InventoryArchetype MENU_SPINNER = ((InventoryArchetype.Builder)builder.reset()).with(MENU_ICON).build("sponge:menu_spinner", "Menu Spinner");
        this.registerAdditionalCatalog(MENU_ICON);
        this.registerAdditionalCatalog(MENU_BUTTON);
        this.registerAdditionalCatalog(MENU_CHECKBOX);
        this.registerAdditionalCatalog(MENU_SPINNER);
    }

    private InventoryArchetypeRegistryModule() {
    }

    private static final class Holder {
        static final InventoryArchetypeRegistryModule INSTANCE = new InventoryArchetypeRegistryModule();

        private Holder() {
        }
    }
}

