/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.statistic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.statistic.achievement.Achievement;
import org.spongepowered.api.statistic.achievement.Achievements;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class AchievementRegistryModule
implements SpongeAdditionalCatalogRegistryModule<Achievement>,
AlternateCatalogRegistryModule<Achievement> {
    @RegisterCatalog(value=Achievements.class)
    private final Map<String, Achievement> achievementMappings = Maps.newHashMap();

    public static AchievementRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    private AchievementRegistryModule() {
    }

    @Override
    public Optional<Achievement> getById(String id) {
        return Optional.ofNullable(this.achievementMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Achievement> getAll() {
        return ImmutableList.copyOf(this.achievementMappings.values());
    }

    @Override
    public void registerAdditionalCatalog(Achievement achievement) {
        Preconditions.checkNotNull((Object)achievement, (Object)"null achievement");
        this.achievementMappings.put(achievement.getId().toLowerCase(Locale.ENGLISH), achievement);
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public Map<String, Achievement> provideCatalogMap() {
        return Maps.newHashMap(this.achievementMappings);
    }

    private static final class Holder {
        static final AchievementRegistryModule INSTANCE = new AchievementRegistryModule();

        private Holder() {
        }
    }
}

