/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityStructure;
import org.spongepowered.api.data.type.StructureMode;
import org.spongepowered.api.data.type.StructureModes;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;

public final class StructureModeRegistryModule
implements CatalogRegistryModule<StructureMode> {
    @RegisterCatalog(value=StructureModes.class)
    public final Map<String, StructureMode> structureModes = Maps.newHashMap();

    @Override
    public void registerDefaults() {
        this.structureModes.put("corner", (StructureMode)TileEntityStructure.Mode.CORNER);
        this.structureModes.put("data", (StructureMode)TileEntityStructure.Mode.DATA);
        this.structureModes.put("load", (StructureMode)TileEntityStructure.Mode.LOAD);
        this.structureModes.put("save", (StructureMode)TileEntityStructure.Mode.SAVE);
    }

    @Override
    public Optional<StructureMode> getById(String id) {
        return Optional.ofNullable(this.structureModes.get(((String)Preconditions.checkNotNull((Object)id, (Object)"id")).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<StructureMode> getAll() {
        return ImmutableSet.copyOf(this.structureModes.values());
    }

    @AdditionalRegistration
    public void customRegistration() {
        for (TileEntityStructure.Mode mode : TileEntityStructure.Mode.values()) {
            String name = mode.name().toLowerCase(Locale.ENGLISH);
            if (this.structureModes.containsKey(name)) continue;
            this.structureModes.put(name, (StructureMode)mode);
        }
    }
}

