/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.world.WorldManager;

public final class DimensionTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<DimensionType> {
    @RegisterCatalog(value=DimensionTypes.class)
    private final Map<String, DimensionType> dimensionTypeMappings = Maps.newHashMap();

    public static DimensionTypeRegistryModule getInstance() {
        return Holder.instance;
    }

    @Override
    public void registerDefaults() {
        for (net.minecraft.world.DimensionType dimensionType : WorldManager.getDimensionTypes()) {
            DimensionType apiDimensionType = (DimensionType)dimensionType;
            this.dimensionTypeMappings.put(apiDimensionType.getId(), apiDimensionType);
        }
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(DimensionType dimType) {
        this.dimensionTypeMappings.put(dimType.getId().toLowerCase(), dimType);
        WorldManager.registerDimensionType((net.minecraft.world.DimensionType)dimType);
    }

    @Override
    public Optional<DimensionType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        id = WorldManager.fixDimensionTypeId(id);
        return Optional.ofNullable(this.dimensionTypeMappings.get(id.toLowerCase()));
    }

    @Override
    public Collection<DimensionType> getAll() {
        return Collections.unmodifiableCollection(this.dimensionTypeMappings.values());
    }

    @AdditionalRegistration
    public void reApplyDimensionTypes() {
        RegistryHelper.mapFields(DimensionTypes.class, this.dimensionTypeMappings);
    }

    private DimensionTypeRegistryModule() {
    }

    private static final class Holder {
        private static final DimensionTypeRegistryModule instance = new DimensionTypeRegistryModule();

        private Holder() {
        }
    }
}

