/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.WorldArchetypes;
import org.spongepowered.api.world.difficulty.Difficulties;
import org.spongepowered.api.world.gen.WorldGeneratorModifiers;
import org.spongepowered.common.registry.type.data.DataFormatRegistryModule;
import org.spongepowered.common.registry.type.entity.GameModeRegistryModule;
import org.spongepowered.common.registry.type.world.DifficultyRegistryModule;
import org.spongepowered.common.registry.type.world.DimensionTypeRegistryModule;
import org.spongepowered.common.registry.type.world.GeneratorTypeRegistryModule;
import org.spongepowered.common.registry.type.world.SerializationBehaviorRegistryModule;
import org.spongepowered.common.registry.type.world.WorldGeneratorModifierRegistryModule;

@RegistrationDependency(value={GameModeRegistryModule.class, GeneratorTypeRegistryModule.class, DifficultyRegistryModule.class, DimensionTypeRegistryModule.class, SerializationBehaviorRegistryModule.class, WorldGeneratorModifierRegistryModule.class, DataFormatRegistryModule.class})
public class WorldArchetypeRegistryModule
implements AdditionalCatalogRegistryModule<WorldArchetype>,
AlternateCatalogRegistryModule<WorldArchetype> {
    @RegisterCatalog(value=WorldArchetypes.class)
    private final Map<String, WorldArchetype> worldCreationSettingsMap = new HashMap<String, WorldArchetype>();

    public static WorldArchetypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        WorldArchetype overworld = WorldArchetype.builder().enabled(true).loadsOnStartup(true).keepsSpawnLoaded(true).generateSpawnOnLoad(true).commandsAllowed(true).gameMode(GameModes.SURVIVAL).generator(GeneratorTypes.DEFAULT).dimension(DimensionTypes.OVERWORLD).difficulty(Difficulties.NORMAL).usesMapFeatures(true).hardcore(false).pvp(true).generateBonusChest(false).serializationBehavior(SerializationBehaviors.AUTOMATIC).build("minecraft:overworld", "Overworld");
        this.worldCreationSettingsMap.put("minecraft:overworld", overworld);
        this.worldCreationSettingsMap.put("minecraft:the_nether", ((WorldArchetype.Builder)WorldArchetype.builder().from(overworld)).generator(GeneratorTypes.NETHER).dimension(DimensionTypes.NETHER).build("minecraft:the_nether", "The Nether"));
        this.worldCreationSettingsMap.put("minecraft:the_end", ((WorldArchetype.Builder)WorldArchetype.builder().from(overworld)).generator(GeneratorTypes.THE_END).dimension(DimensionTypes.THE_END).build("minecraft:the_end", "The End"));
        this.worldCreationSettingsMap.put("sponge:the_skylands", ((WorldArchetype.Builder)WorldArchetype.builder().from(overworld)).generatorModifiers(WorldGeneratorModifiers.SKYLANDS).build("sponge:the_skylands", "The Skylands"));
        this.worldCreationSettingsMap.put("sponge:the_void", ((WorldArchetype.Builder)WorldArchetype.builder().from(overworld)).generatorModifiers(WorldGeneratorModifiers.VOID).build("sponge:the_void", "The Void"));
    }

    @Override
    public void registerAdditionalCatalog(WorldArchetype extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog, (Object)"WorldArchetype cannot be null!");
        String id = extraCatalog.getId().toLowerCase(Locale.ENGLISH);
        this.worldCreationSettingsMap.put(id, extraCatalog);
    }

    @Override
    public Optional<WorldArchetype> getById(String id) {
        return Optional.ofNullable(this.worldCreationSettingsMap.get(((String)Preconditions.checkNotNull((Object)id, (Object)"WorldCreationSettings ID cannot be null!")).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<WorldArchetype> getAll() {
        return Collections.unmodifiableCollection(this.worldCreationSettingsMap.values());
    }

    @Override
    public Map<String, WorldArchetype> provideCatalogMap() {
        HashMap<String, WorldArchetype> provided = new HashMap<String, WorldArchetype>();
        for (Map.Entry<String, WorldArchetype> entry : this.worldCreationSettingsMap.entrySet()) {
            provided.put(entry.getKey().replace("minecraft:", "").replace("sponge:", ""), entry.getValue());
        }
        return provided;
    }

    WorldArchetypeRegistryModule() {
    }

    private static final class Holder {
        static final WorldArchetypeRegistryModule INSTANCE = new WorldArchetypeRegistryModule();

        private Holder() {
        }
    }
}

