/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.permission.SpongePermissionService;

class SpongePermissionDescription
implements PermissionDescription {
    private final PermissionService permissionService;
    private final String id;
    private final Text description;
    private final PluginContainer owner;

    SpongePermissionDescription(PermissionService permissionService, String id, Text description, PluginContainer owner) {
        this.permissionService = (PermissionService)Preconditions.checkNotNull((Object)permissionService, (Object)"permissionService");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.description = (Text)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.owner = (PluginContainer)Preconditions.checkNotNull((Object)owner, (Object)"owner");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Text getDescription() {
        return this.description;
    }

    @Override
    public Map<Subject, Boolean> getAssignedSubjects(String identifier) {
        SubjectCollection subjects = this.permissionService.getSubjects(identifier);
        return subjects.getAllWithPermission(this.id);
    }

    @Override
    public PluginContainer getOwner() {
        return this.owner;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpongePermissionDescription other = (SpongePermissionDescription)obj;
        return this.id.equals(other.id) && this.owner.equals(other.owner) && this.description.equals(other.description);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("owner", (Object)this.owner).add("id", (Object)this.id).toString();
    }

    static class Builder
    implements PermissionDescription.Builder {
        private final SpongePermissionService permissionService;
        private final PluginContainer owner;
        private String id;
        private Text description;
        private Optional<String> suggestedRank = Optional.empty();
        private final Map<String, Tristate> roleAssignments = new LinkedHashMap<String, Tristate>();

        Builder(SpongePermissionService permissionService, PluginContainer owner) {
            this.permissionService = (SpongePermissionService)Preconditions.checkNotNull((Object)permissionService, (Object)"permissionService");
            this.owner = (PluginContainer)Preconditions.checkNotNull((Object)owner, (Object)"owner");
        }

        @Override
        public Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"permissionId");
            return this;
        }

        @Override
        public Builder description(Text description) {
            this.description = (Text)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        @Override
        public Builder assign(String role, boolean value) {
            Preconditions.checkNotNull((Object)role, (Object)"role");
            this.roleAssignments.put(role, Tristate.fromBoolean(value));
            return this;
        }

        @Override
        public SpongePermissionDescription register() throws IllegalStateException {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"No id set");
            Preconditions.checkState((this.description != null ? 1 : 0) != 0, (Object)"No description set");
            SpongePermissionDescription description = new SpongePermissionDescription(this.permissionService, this.id, this.description, this.owner);
            this.permissionService.addDescription(description);
            SubjectCollection subjects = this.permissionService.getSubjects("role-template");
            for (Map.Entry<String, Tristate> assignment : this.roleAssignments.entrySet()) {
                Subject subject = subjects.get(assignment.getKey());
                subject.getTransientSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, this.id, assignment.getValue());
            }
            return description;
        }
    }
}

