/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission.base;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.Tristate;

public class GlobalMemorySubjectData
extends MemorySubjectData {
    public GlobalMemorySubjectData(PermissionService service) {
        super(service);
    }

    @Override
    public Map<Set<Context>, List<Subject>> getAllParents() {
        return ImmutableMap.of((Object)GLOBAL_CONTEXT, this.getParents(GLOBAL_CONTEXT));
    }

    @Override
    public boolean setPermission(Set<Context> contexts, String permission, Tristate value) {
        if (!GLOBAL_CONTEXT.equals(contexts)) {
            return false;
        }
        return super.setPermission(contexts, permission, value);
    }

    @Override
    public boolean clearPermissions(Set<Context> contexts) {
        if (!GLOBAL_CONTEXT.equals(contexts)) {
            return false;
        }
        return super.clearPermissions(contexts);
    }

    @Override
    public boolean addParent(Set<Context> contexts, Subject parent) {
        if (!GLOBAL_CONTEXT.equals(contexts)) {
            return false;
        }
        return super.addParent(contexts, parent);
    }

    @Override
    public boolean removeParent(Set<Context> contexts, Subject parent) {
        if (!GLOBAL_CONTEXT.equals(contexts)) {
            return false;
        }
        return super.removeParent(contexts, parent);
    }

    @Override
    public boolean clearParents(Set<Context> contexts) {
        if (!GLOBAL_CONTEXT.equals(contexts)) {
            return false;
        }
        return super.clearParents(contexts);
    }
}

