/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission.base;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;

public abstract class SpongeSubject
implements Subject {
    @Override
    public MemorySubjectData getTransientSubjectData() {
        return this.getSubjectData();
    }

    @Override
    public abstract MemorySubjectData getSubjectData();

    @Override
    public boolean hasPermission(Set<Context> contexts, String permission) {
        return this.getPermissionValue(contexts, permission) == Tristate.TRUE;
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        return this.getDataPermissionValue(this.getSubjectData(), permission);
    }

    protected Tristate getDataPermissionValue(MemorySubjectData subject, String permission) {
        Tristate res = subject.getNodeTree(SubjectData.GLOBAL_CONTEXT).get(permission);
        if (res == Tristate.UNDEFINED) {
            for (Subject parent : subject.getParents(SubjectData.GLOBAL_CONTEXT)) {
                Tristate tempRes = parent.getPermissionValue(SubjectData.GLOBAL_CONTEXT, permission);
                if (tempRes == Tristate.UNDEFINED) continue;
                res = tempRes;
                break;
            }
        }
        return res;
    }

    @Override
    public boolean isChildOf(Set<Context> contexts, Subject parent) {
        return this.getSubjectData().getParents(contexts).contains(parent);
    }

    @Override
    public List<Subject> getParents(Set<Context> contexts) {
        return this.getSubjectData().getParents(contexts);
    }

    protected Optional<String> getDataOptionValue(MemorySubjectData subject, String option) {
        Optional<String> res = Optional.ofNullable(subject.getOptions(SubjectData.GLOBAL_CONTEXT).get(option));
        if (!res.isPresent()) {
            for (Subject parent : subject.getParents(SubjectData.GLOBAL_CONTEXT)) {
                Optional<String> tempRes = parent.getOption(SubjectData.GLOBAL_CONTEXT, option);
                if (!tempRes.isPresent()) continue;
                res = tempRes;
                break;
            }
        }
        return res;
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String key) {
        return this.getDataOptionValue(this.getSubjectData(), key);
    }

    @Override
    public Set<Context> getActiveContexts() {
        return SubjectData.GLOBAL_CONTEXT;
    }
}

