/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.permission.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.permission.base.SpongeSubject;

public abstract class SpongeSubjectCollection
implements SubjectCollection {
    private final String identifier;
    protected final SpongePermissionService service;

    protected SpongeSubjectCollection(String identifier, SpongePermissionService service) {
        this.identifier = identifier;
        this.service = service;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public SpongeSubject getDefaults() {
        return this.service.getDefaultCollection().get(this.getIdentifier());
    }

    @Override
    public Map<Subject, Boolean> getAllWithPermission(String permission) {
        HashMap<Subject, Boolean> ret = new HashMap<Subject, Boolean>();
        for (Subject subj : this.getAllSubjects()) {
            Tristate state = subj.getPermissionValue(subj.getActiveContexts(), permission);
            if (state == Tristate.UNDEFINED) continue;
            ret.put(subj, state.asBoolean());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public Map<Subject, Boolean> getAllWithPermission(Set<Context> contexts, String permission) {
        HashMap<Subject, Boolean> ret = new HashMap<Subject, Boolean>();
        for (Subject subj : this.getAllSubjects()) {
            Tristate state = subj.getPermissionValue(contexts, permission);
            if (state == Tristate.UNDEFINED) continue;
            ret.put(subj, state.asBoolean());
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public abstract SpongeSubject get(String var1);
}

