/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.serializer.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlSeeAlso;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.interfaces.text.IMixinClickEvent;
import org.spongepowered.common.interfaces.text.IMixinHoverEvent;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.text.action.SpongeClickAction;
import org.spongepowered.common.text.action.SpongeHoverAction;
import org.spongepowered.common.text.serializer.xml.A;
import org.spongepowered.common.text.serializer.xml.B;
import org.spongepowered.common.text.serializer.xml.Color;
import org.spongepowered.common.text.serializer.xml.I;
import org.spongepowered.common.text.serializer.xml.Obfuscated;
import org.spongepowered.common.text.serializer.xml.Span;
import org.spongepowered.common.text.serializer.xml.Strikethrough;
import org.spongepowered.common.text.serializer.xml.Tr;
import org.spongepowered.common.text.serializer.xml.U;

@XmlSeeAlso(value={A.class, B.class, Color.class, I.class, Obfuscated.class, Strikethrough.class, Span.class, Tr.class, U.class})
public abstract class Element {
    @XmlAttribute
    private String onClick = null;
    @XmlAttribute
    private String onShiftClick = null;
    @XmlAttribute
    private String onHover = null;
    @XmlElementRef(type=Element.class)
    @XmlMixed
    protected List<Object> mixedContent = new ArrayList<Object>();
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("^([^(]+)\\('(.*)'\\)$");

    protected abstract void modifyBuilder(Text.Builder var1);

    protected void applyTextActions(Text.Builder builder) throws Exception {
        String eventString;
        String eventType;
        Matcher matcher;
        if (this.onClick != null) {
            matcher = FUNCTION_PATTERN.matcher(this.onClick);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid onClick handler in " + this.getClass().getSimpleName() + " tag.");
            }
            eventType = matcher.group(1);
            eventString = matcher.group(2);
            ClickEvent.Action enumClickAction = ClickEvent.Action.func_150672_a((String)eventType.toLowerCase());
            if (enumClickAction == null) {
                throw new RuntimeException("Unknown onClick action " + eventType + " in " + this.getClass().getSimpleName() + " tag.");
            }
            builder.onClick(((IMixinClickEvent)new ClickEvent(enumClickAction, eventString)).getHandle());
        }
        if (this.onShiftClick != null) {
            matcher = FUNCTION_PATTERN.matcher(this.onShiftClick);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid onShiftClick handler in " + this.getClass().getSimpleName() + " tag.");
            }
            eventType = matcher.group(1);
            eventString = matcher.group(2);
            if (!eventType.equalsIgnoreCase("insert_text")) {
                throw new RuntimeException("Unknown onShiftClick action " + eventType + " in " + this.getClass().getSimpleName() + " tag.");
            }
            builder.onShiftClick(TextActions.insertText(eventString));
        }
        if (this.onHover != null) {
            matcher = FUNCTION_PATTERN.matcher(this.onHover);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid onHover handler in " + this.getClass().getSimpleName() + " tag.");
            }
            eventType = matcher.group(1);
            eventString = matcher.group(2);
            HoverEvent.Action enumHoverAction = HoverEvent.Action.func_150684_a((String)eventType.toLowerCase());
            if (enumHoverAction == null) {
                throw new RuntimeException("Unknown onHover action " + eventType + " in " + this.getClass().getSimpleName() + " tag.");
            }
            if (enumHoverAction == HoverEvent.Action.SHOW_TEXT) {
                builder.onHover(TextActions.showText(TextSerializers.TEXT_XML.deserialize(eventString)));
            } else {
                builder.onHover(((IMixinHoverEvent)new HoverEvent(enumHoverAction, SpongeTexts.toComponent(TextSerializers.TEXT_XML.deserialize(eventString)))).getHandle());
            }
        }
    }

    public Text.Builder toText() throws Exception {
        Text.Builder builder;
        if (this.mixedContent.size() == 0) {
            builder = Text.builder();
        } else if (this.mixedContent.size() == 1) {
            builder = this.builderFromObject(this.mixedContent.get(0));
        } else {
            if (this.mixedContent.get(0) instanceof String) {
                builder = this.builderFromObject(this.mixedContent.get(0));
                this.mixedContent.remove(0);
            } else {
                builder = Text.builder();
            }
            for (Object child : this.mixedContent) {
                builder.append(this.builderFromObject(child).build());
            }
        }
        this.modifyBuilder(builder);
        this.applyTextActions(builder);
        return builder;
    }

    protected Text.Builder builderFromObject(Object o) throws Exception {
        if (o instanceof String) {
            return Text.builder(String.valueOf(o).replace('\u000b', ' '));
        }
        if (o instanceof Element) {
            return ((Element)o).toText();
        }
        throw new IllegalArgumentException("What is this even? " + o);
    }

    public static Element fromText(Text text) {
        HoverEvent nmsEvent;
        AtomicReference<Element> fixedRoot = new AtomicReference<Element>();
        Element currentElement = null;
        if (text.getColor() != TextColors.NONE) {
            currentElement = Element.update(fixedRoot, currentElement, new Color.C(text.getColor()));
        }
        if (text.getStyle().contains(TextStyles.BOLD)) {
            currentElement = Element.update(fixedRoot, currentElement, new B());
        }
        if (text.getStyle().contains(TextStyles.ITALIC)) {
            currentElement = Element.update(fixedRoot, currentElement, new I());
        }
        if (text.getStyle().contains(TextStyles.OBFUSCATED)) {
            currentElement = Element.update(fixedRoot, currentElement, new Obfuscated.O());
        }
        if (text.getStyle().contains(TextStyles.STRIKETHROUGH)) {
            currentElement = Element.update(fixedRoot, currentElement, new Strikethrough.S());
        }
        if (text.getStyle().contains(TextStyles.UNDERLINE)) {
            currentElement = Element.update(fixedRoot, currentElement, new U());
        }
        if (text.getClickAction().isPresent()) {
            if (text.getClickAction().get() instanceof ClickAction.OpenUrl) {
                currentElement = Element.update(fixedRoot, currentElement, new A((URL)((ClickAction.OpenUrl)text.getClickAction().get()).getResult()));
            } else {
                if (currentElement == null) {
                    currentElement = new Span();
                    fixedRoot.set(currentElement);
                }
                nmsEvent = SpongeClickAction.getHandle(text.getClickAction().get());
                currentElement.onClick = nmsEvent.func_150669_a().func_150673_b() + "('" + nmsEvent.func_150668_b() + "')";
            }
        } else if (currentElement == null) {
            currentElement = new Span();
            fixedRoot.set(currentElement);
        }
        if (text.getHoverAction().isPresent()) {
            nmsEvent = SpongeHoverAction.getHandle(text.getHoverAction().get());
            currentElement.onHover = nmsEvent.func_150701_a().func_150685_b() + "('" + TextSerializers.TEXT_XML.serialize(SpongeTexts.toText(nmsEvent.func_150702_b())) + "')";
        }
        if (text.getShiftClickAction().isPresent()) {
            ShiftClickAction<?> action = text.getShiftClickAction().get();
            if (!(action instanceof ShiftClickAction.InsertText)) {
                throw new IllegalArgumentException("Shift-click action is not an insertion. Currently not supported!");
            }
            currentElement.onShiftClick = "insert_text('" + action.getResult() + "')";
        }
        if (text instanceof LiteralText) {
            currentElement.mixedContent.add(((LiteralText)text).getContent());
        } else if (text instanceof TranslatableText) {
            Translation transl = ((TranslatableText)text).getTranslation();
            currentElement = Element.update(fixedRoot, currentElement, new Tr(transl.getId()));
            for (Object o : ((TranslatableText)text).getArguments()) {
                if (o instanceof Text) {
                    currentElement.mixedContent.add(Element.fromText((Text)o));
                    continue;
                }
                currentElement.mixedContent.add(String.valueOf(o));
            }
        } else {
            throw new IllegalArgumentException("Text was of type " + text.getClass() + ", which is unsupported by the XML format");
        }
        for (Text child : text.getChildren()) {
            currentElement.mixedContent.add(Element.fromText(child));
        }
        return fixedRoot.get();
    }

    private static Element update(AtomicReference<Element> fixedRoot, @Nullable Element parent, Element child) {
        if (parent == null) {
            fixedRoot.set(child);
            return child;
        }
        parent.mixedContent.add(child);
        return child;
    }
}

