/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.serializer.xml;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshallerHandler;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextParseException;
import org.spongepowered.api.text.serializer.TextSerializer;
import org.spongepowered.common.text.serializer.xml.Element;
import org.spongepowered.common.text.serializer.xml.WhitespaceAwareUnmarshallerHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TextXmlTextSerializer
implements TextSerializer {
    private static final JAXBContext CONTEXT;

    @Override
    public String getId() {
        return "sponge:text_xml";
    }

    @Override
    public String getName() {
        return "TextXML";
    }

    @Override
    public String serialize(Text text) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)Element.fromText(text), (Writer)writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return writer.getBuffer().toString();
    }

    private static <T> T unmarshal(JAXBContext ctx, String strData, boolean flgWhitespaceAware) throws Exception {
        UnmarshallerHandler uh = ctx.createUnmarshaller().getUnmarshallerHandler();
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setContentHandler(flgWhitespaceAware ? new WhitespaceAwareUnmarshallerHandler(uh) : uh);
        xr.setErrorHandler(new DefaultHandler());
        xr.parse(new InputSource(new StringReader(strData)));
        return (T)uh.getResult();
    }

    @Override
    public Text deserialize(String input) throws TextParseException {
        try {
            input = "<span>" + input + "</span>";
            Element element = (Element)TextXmlTextSerializer.unmarshal(CONTEXT, input, true);
            return element.toText().build();
        }
        catch (Exception e) {
            throw new TextParseException("Error parsing TextXML message", e);
        }
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Element.class});
        }
        catch (JAXBException e) {
            ExceptionInInitializerError err = new ExceptionInInitializerError("Error creating JAXB context: " + (Object)((Object)e));
            err.initCause(e);
            throw err;
        }
    }
}

