/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.util.NbtDataUtil;

public final class ColorUtil {
    public static Optional<Color> getItemStackColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemArmor) {
            int color = ((ItemArmor)item).func_82814_b(stack);
            return color == -1 ? Optional.empty() : Optional.of(Color.ofRgb(color));
        }
        return NbtDataUtil.getItemCompound(stack).flatMap(NbtDataUtil::getColorFromNBT);
    }

    public static int javaColorToMojangColor(Color color) {
        Preconditions.checkNotNull((Object)color);
        return ((color.getRed() << 8) + color.getGreen() << 8) + color.getBlue();
    }

    public static int dyeColorToMojangColor(DyeColor dyeColor) {
        float[] dyeRgbArray = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.valueOf((String)dyeColor.getName().toUpperCase()));
        int trueRed = (int)(dyeRgbArray[0] * 255.0f);
        int trueGreen = (int)(dyeRgbArray[1] * 255.0f);
        int trueBlue = (int)(dyeRgbArray[2] * 255.0f);
        int combinedRg = (trueRed << 8) + trueGreen;
        int actualColor = (combinedRg << 8) + trueBlue;
        return actualColor;
    }

    public static Color fromDyeColor(DyeColor dyeColor) {
        float[] dyeRgbArray = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.valueOf((String)dyeColor.getName().toUpperCase()));
        int trueRed = (int)(dyeRgbArray[0] * 255.0f);
        int trueGreen = (int)(dyeRgbArray[1] * 255.0f);
        int trueBlue = (int)(dyeRgbArray[2] * 255.0f);
        return Color.ofRgb(trueRed, trueGreen, trueBlue);
    }

    public static EnumDyeColor fromColor(Color color) {
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            Color color1 = ColorUtil.fromDyeColor((DyeColor)enumDyeColor);
            if (!color.equals(color1)) continue;
            return enumDyeColor;
        }
        return EnumDyeColor.WHITE;
    }

    public static void setItemStackColor(ItemStack stack, Color value) {
        NbtDataUtil.setColorToNbt(stack, value);
    }

    public static boolean hasColorInNbt(ItemStack stack) {
        return NbtDataUtil.hasColorFromNBT(stack);
    }

    public static boolean hasColor(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemArmor && ((ItemArmor)item).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER;
    }

    private ColorUtil() {
    }
}

