/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.launch.SpongeLaunch;

public final class PathTokens {
    public static final String PATHTOKEN_CANONICAL_GAME_DIR = "CANONICAL_GAME_DIR";
    public static final String PATHTOKEN_CANONICAL_MODS_DIR = "CANONICAL_MODS_DIR";
    public static final String PATHTOKEN_CANONICAL_CONFIG_DIR = "CANONICAL_CONFIG_DIR";
    public static final String PATHTOKEN_MC_VERSION = "MC_VERSION";

    private PathTokens() {
    }

    public static String replace(String string) {
        Map<String, String> tokens = PathTokens.getPathTokens();
        for (Map.Entry<String, String> token : tokens.entrySet()) {
            string = string.replace(token.getKey(), token.getValue());
        }
        return string;
    }

    private static Map<String, String> getPathTokens() {
        HashMap tokens = Maps.newHashMap();
        tokens.put(PathTokens.formatToken(PATHTOKEN_CANONICAL_MODS_DIR), SpongeLaunch.getPluginsDir().toFile().getAbsolutePath());
        tokens.put(PathTokens.formatToken(PATHTOKEN_CANONICAL_GAME_DIR), SpongeLaunch.getGameDir().toFile().getAbsolutePath());
        tokens.put(PathTokens.formatToken(PATHTOKEN_CANONICAL_CONFIG_DIR), SpongeLaunch.getConfigDir().toFile().getAbsolutePath());
        tokens.put(PathTokens.formatToken(PATHTOKEN_MC_VERSION), SpongeImpl.MINECRAFT_VERSION.getName());
        return tokens;
    }

    private static String formatToken(String name) {
        return String.format("${%s}", name);
    }
}

