/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.spongepowered.common.SpongeImpl;

public final class SpongeUsernameCache {
    private static Map<UUID, String> map = new ConcurrentHashMap<UUID, String>();
    private static final Charset charset = Charsets.UTF_8;
    private static final File saveFile = new File(".", "usernamecache.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static boolean loaded = false;

    public static void setUsername(UUID uuid, String username) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)username);
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        if (username.equals(map.get(uuid))) {
            return;
        }
        map.put(uuid, username);
    }

    public static boolean removeUsername(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        return map.remove(uuid) != null;
    }

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        return map.get(uuid);
    }

    @Nullable
    public static UUID getLastKnownUUID(String username) {
        Preconditions.checkNotNull((Object)username);
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        for (Map.Entry<UUID, String> mapEntry : map.entrySet()) {
            if (!mapEntry.getValue().equalsIgnoreCase(username)) continue;
            return mapEntry.getKey();
        }
        return null;
    }

    public static boolean containsUUID(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        return map.containsKey(uuid);
    }

    public static Map<UUID, String> getMap() {
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        return ImmutableMap.copyOf(map);
    }

    public static void save() {
        if (!loaded) {
            SpongeUsernameCache.load();
        }
        try {
            Files.write((CharSequence)gson.toJson(map), (File)saveFile, (Charset)charset);
        }
        catch (IOException e) {
            SpongeImpl.getLogger().error("Failed to save username cache to file!", (Throwable)e);
        }
    }

    public static void load() {
        loaded = true;
        if (!saveFile.exists()) {
            return;
        }
        try {
            String json = Files.toString((File)saveFile, (Charset)charset);
            Type type = new TypeToken<Map<UUID, String>>(){
                private static final long serialVersionUID = 1L;
            }.getType();
            map = (Map)gson.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            SpongeImpl.getLogger().error("Could not parse username cache file as valid json, deleting file", (Throwable)e);
            saveFile.delete();
        }
        catch (IOException e) {
            SpongeImpl.getLogger().error("Failed to read username cache file from disk, deleting file", (Throwable)e);
            saveFile.delete();
        }
        finally {
            if (map == null) {
                map = Maps.newHashMap();
            }
        }
    }
}

