/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.extent.BiomeVolume;
import org.spongepowered.common.util.VecHelper;

public abstract class AbstractBiomeBuffer
implements BiomeVolume {
    protected Vector3i start;
    protected Vector3i size;
    protected Vector3i end;
    private final int xLine;

    protected AbstractBiomeBuffer(Vector3i start, Vector3i size) {
        Preconditions.checkArgument((size.getY() == 1 ? 1 : 0) != 0, (Object)"Size y coordinate should be 1");
        this.start = start;
        this.size = size;
        this.end = this.start.add(this.size).sub(Vector3i.ONE);
        this.xLine = size.getX();
    }

    protected final void checkRange(int x, int y, int z) {
        if (!VecHelper.inBounds(x, y, z, this.start, this.end)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), this.start, this.end);
        }
    }

    protected int getIndex(int x, int z) {
        return (z - this.start.getZ()) * this.xLine + (x - this.start.getX());
    }

    @Override
    public Vector3i getBiomeMin() {
        return this.start;
    }

    @Override
    public Vector3i getBiomeMax() {
        return this.end;
    }

    @Override
    public Vector3i getBiomeSize() {
        return this.size;
    }

    @Override
    public boolean containsBiome(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, this.start, this.end);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("min", (Object)this.getBiomeMin()).add("max", (Object)this.getBiomeMax()).toString();
    }
}

