/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.BlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.extent.ImmutableBlockViewDownsize;
import org.spongepowered.common.world.extent.ImmutableBlockViewTransform;
import org.spongepowered.common.world.extent.worker.SpongeBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;

public class ArrayImmutableBlockBuffer
extends AbstractBlockBuffer
implements ImmutableBlockVolume {
    private static final BlockState AIR = BlockTypes.AIR.getDefaultState();
    private final BlockPalette palette;
    private final ArrayMutableBlockBuffer.BackingData data;

    ArrayImmutableBlockBuffer(BlockPalette palette, ArrayMutableBlockBuffer.BackingData data, Vector3i start, Vector3i size) {
        super(start, size);
        this.data = data;
        this.palette = palette;
    }

    public ArrayImmutableBlockBuffer(BlockPalette palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.data = new ArrayMutableBlockBuffer.CharBackingData((char[])blocks.clone());
        this.palette = palette;
    }

    @Override
    public BlockPalette getPalette() {
        return GlobalPalette.instance;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.palette.get(this.data.get(this.getIndex(x, y, z))).orElse(AIR);
    }

    @Override
    public ImmutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new ImmutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    public ImmutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new ImmutableBlockViewTransform(this, transform);
    }

    @Override
    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return this;
    }

    @Override
    public BlockVolumeWorker<? extends ImmutableBlockVolume> getBlockWorker(Cause cause) {
        return new SpongeBlockVolumeWorker<ArrayImmutableBlockBuffer>(this, cause);
    }

    @Override
    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    public static ImmutableBlockVolume newWithoutArrayClone(BlockPalette palette, Vector3i start, Vector3i size, char[] blocks) {
        return new ArrayImmutableBlockBuffer(palette, new ArrayMutableBlockBuffer.CharBackingData(blocks), start, size);
    }
}

