/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.util.gen.ArrayImmutableBlockBuffer;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.GlobalPalette;

public class ArrayMutableBlockBuffer
extends AbstractBlockBuffer
implements MutableBlockVolume {
    private static final int SMALL_AREA_THRESHOLD = 256;
    private static final BlockState AIR = BlockTypes.AIR.getDefaultState();
    private BlockPalette palette;
    private BackingData data;

    public ArrayMutableBlockBuffer(Vector3i start, Vector3i size) {
        this(size.getX() * size.getY() * size.getZ() > 256 ? new BimapPalette() : GlobalPalette.instance, start, size);
    }

    public ArrayMutableBlockBuffer(BlockPalette palette, Vector3i start, Vector3i size) {
        super(start, size);
        this.palette = palette;
        int airId = palette.getOrAssign(AIR);
        int dataSize = this.area();
        this.data = new PackedBackingData(dataSize, palette.getHighestId());
        if (airId != 0) {
            for (int i = 0; i < dataSize; ++i) {
                this.data.set(i, airId);
            }
        }
    }

    public ArrayMutableBlockBuffer(BlockPalette palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.palette = palette;
        this.data = new CharBackingData(blocks);
    }

    ArrayMutableBlockBuffer(BlockPalette palette, BackingData blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.palette = palette;
        this.data = blocks;
    }

    @Override
    public BlockPalette getPalette() {
        return this.palette;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block, Cause cause) {
        this.checkRange(x, y, z);
        int id = this.palette.getOrAssign(block);
        if (id > this.data.getMax()) {
            PackedBackingData newdata;
            int highId = this.palette.getHighestId();
            int dataSize = this.area();
            if (highId * 2 > GlobalPalette.instance.getHighestId()) {
                GlobalPalette newpalette = GlobalPalette.instance;
                id = newpalette.getOrAssign(block);
                highId = newpalette.getHighestId();
                newdata = new PackedBackingData(dataSize, highId);
                for (int i = 0; i < dataSize; ++i) {
                    newdata.set(i, newpalette.getOrAssign(this.palette.get(this.data.get(i)).orElse(AIR)));
                }
                this.palette = newpalette;
            } else {
                newdata = new PackedBackingData(dataSize, highId);
                for (int i = 0; i < dataSize; ++i) {
                    newdata.set(i, this.data.get(i));
                }
            }
            this.data = newdata;
        }
        this.data.set(this.getIndex(x, y, z), id);
        return true;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.palette.get(this.data.get(this.getIndex(x, y, z))).orElse(AIR);
    }

    @Override
    public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBlockViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform(this, transform);
    }

    @Override
    public MutableBlockVolumeWorker<? extends MutableBlockVolume> getBlockWorker(Cause cause) {
        return new SpongeMutableBlockVolumeWorker<ArrayMutableBlockBuffer>(this, cause);
    }

    @Override
    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper(this);
    }

    @Override
    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBlockVolume getImmutableBlockCopy() {
        return new ArrayImmutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size);
    }

    private int area() {
        return this.size.getX() * this.size.getY() * this.size.getZ();
    }

    static class PackedBackingData
    implements BackingData {
        private long[] longArray;
        private final int bits;
        private final long maxValue;
        private final int arraySize;

        public PackedBackingData(int size, int highestValue) {
            this.arraySize = size;
            int bits = 0;
            while (1 << bits <= highestValue) {
                ++bits;
            }
            this.bits = bits;
            this.maxValue = (1 << bits) - 1;
            this.longArray = new long[MathHelper.func_154354_b((int)(size * bits), (int)64) / 64];
        }

        private PackedBackingData(int size, int bits, long[] array) {
            this.arraySize = size;
            this.bits = bits;
            this.maxValue = (1 << bits) - 1;
            this.longArray = array;
        }

        @Override
        public void set(int index, int value) {
            int bitIndex = index * this.bits;
            int longIndex = bitIndex / 64;
            int bitOffset = bitIndex % 64;
            this.longArray[longIndex] = this.longArray[longIndex] & (this.maxValue << bitOffset ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << bitOffset;
            if (bitOffset + this.bits > 64) {
                int bitsInLeft = 64 - bitOffset;
                int bitsInRight = this.bits - bitsInLeft;
                this.longArray[++longIndex] = this.longArray[longIndex] >>> bitsInRight << bitsInRight | (long)value >> bitsInLeft;
            }
        }

        @Override
        public int get(int index) {
            int bitIndex = index * this.bits;
            int longIndex = bitIndex / 64;
            int rightLongIndex = (bitIndex + this.bits - 1) / 64;
            int bitOffset = bitIndex % 64;
            if (bitOffset + this.bits > 64) {
                int bitsInLeft = 64 - bitOffset;
                return (int)((this.longArray[longIndex] >>> bitOffset | this.longArray[rightLongIndex] << bitsInLeft) & this.maxValue);
            }
            return (int)(this.longArray[longIndex] >>> bitOffset & this.maxValue);
        }

        @Override
        public PackedBackingData copyOf() {
            return new PackedBackingData(this.arraySize, this.bits, (long[])this.longArray.clone());
        }

        @Override
        public int getMax() {
            return (int)this.maxValue;
        }
    }

    static class CharBackingData
    implements BackingData {
        private final char[] data;

        public CharBackingData(char[] data) {
            this.data = data;
        }

        @Override
        public int get(int index) {
            return this.data[index];
        }

        @Override
        public void set(int index, int val) {
            this.data[index] = (char)val;
        }

        @Override
        public BackingData copyOf() {
            return new CharBackingData((char[])this.data.clone());
        }

        @Override
        public int getMax() {
            return 65535;
        }
    }

    static interface BackingData {
        public int get(int var1);

        public void set(int var1, int var2);

        public BackingData copyOf();

        public int getMax();
    }
}

