/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.api.world.World;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;

@Singleton
public class SpongeTeleportHelper
implements TeleportHelper {
    @Override
    public Optional<Location<World>> getSafeLocation(Location<World> location) {
        return this.getSafeLocation(location, 3, 9);
    }

    @Override
    public Optional<Location<World>> getSafeLocation(Location<World> location, int height, int width) {
        World world = location.getExtent();
        IMixinChunkProviderServer chunkProviderServer = (IMixinChunkProviderServer)((WorldServer)world).func_72863_F();
        chunkProviderServer.setForceChunkRequests(true);
        HashMap blockCache = new HashMap();
        Optional<Vector3i> result = this.getBlockLocations(location, height, width).filter(currentTarget -> {
            BlockData block = this.getBlockData((Vector3i)currentTarget, world, blockCache);
            return block.isSafeBody && this.getBlockData(currentTarget.add(0, 1, 0), world, blockCache).isSafeBody && this.isFloorSafe((Vector3i)currentTarget, world, blockCache);
        }).findFirst();
        chunkProviderServer.setForceChunkRequests(false);
        if (result.isPresent()) {
            return Optional.of(new Location<World>(world, result.get().toDouble().add(0.5, 0.0, 0.5)));
        }
        return Optional.empty();
    }

    private boolean isFloorSafe(Vector3i currentTarget, World world, Map<Vector3i, BlockData> blockCache) {
        BlockData data = this.getBlockData(currentTarget.sub(0, 1, 0), world, blockCache);
        if (data.isSafeFloor) {
            return true;
        }
        if (!data.isSafeBody) {
            return false;
        }
        return this.getBlockData(currentTarget.sub(0, 2, 0), world, blockCache).isSafeFloor;
    }

    private Stream<Vector3i> getBlockLocations(Location<World> worldLocation, int height, int width) {
        WorldBorder worldBorder = (WorldBorder)worldLocation.getExtent().getWorldBorder();
        int worldBorderMinX = GenericMath.floor(worldBorder.func_177726_b());
        int worldBorderMinZ = GenericMath.floor(worldBorder.func_177736_c());
        int worldBorderMaxX = GenericMath.floor(worldBorder.func_177728_d());
        int worldBorderMaxZ = GenericMath.floor(worldBorder.func_177733_e());
        int worldMaxY = worldLocation.getExtent().getBlockMax().getY();
        Vector3i vectorLocation = worldLocation.getBlockPosition();
        int minY = GenericMath.clamp(vectorLocation.getY() - height, 0, worldMaxY);
        int maxY = GenericMath.clamp(vectorLocation.getY() + height, 0, worldMaxY);
        int minX = GenericMath.clamp(vectorLocation.getX() - width, worldBorderMinX, worldBorderMaxX);
        int maxX = GenericMath.clamp(vectorLocation.getX() + width, worldBorderMinX, worldBorderMaxX);
        int minZ = GenericMath.clamp(vectorLocation.getZ() - width, worldBorderMinZ, worldBorderMaxZ);
        int maxZ = GenericMath.clamp(vectorLocation.getZ() + width, worldBorderMinZ, worldBorderMaxZ);
        ArrayList<Vector3i> vectors = new ArrayList<Vector3i>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    vectors.add(new Vector3i(x, y, z));
                }
            }
        }
        return vectors.stream().sorted(Comparator.comparingInt(vectorLocation::distanceSquared));
    }

    private BlockData getBlockData(Vector3i vector3i, World world, Map<Vector3i, BlockData> cache) {
        if (vector3i.getY() < 0) {
            return new BlockData(null);
        }
        if (cache.containsKey(vector3i)) {
            return cache.get(vector3i);
        }
        BlockData data = new BlockData(BlockUtil.toNative(world.getBlock(vector3i)).func_185904_a());
        cache.put(vector3i, data);
        return data;
    }

    private class BlockData {
        private final boolean isSafeBody;
        private final boolean isSafeFloor;

        private BlockData(Material material) {
            this.isSafeBody = this.isSafeBodyMaterial(material);
            this.isSafeFloor = this.isSafeFloorMaterial(material);
        }

        private boolean isSafeFloorMaterial(@Nullable Material material) {
            return material != null && material != Material.field_151579_a && material != Material.field_151570_A && material != Material.field_151581_o && material != Material.field_151587_i;
        }

        private boolean isSafeBodyMaterial(@Nullable Material material) {
            return material != null && (material == Material.field_151579_a || material == Material.field_151585_k || material == Material.field_151586_h || material == Material.field_151591_t || material == Material.field_151594_q || material == Material.field_151597_y || material == Material.field_151567_E || material == Material.field_151569_G || material == Material.field_151582_l);
        }
    }
}

