/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.common.util.NonNullArrayList;

public class SpongeBiomeGenerationSettings
implements BiomeGenerationSettings {
    private float minHeight;
    private float maxHeight;
    private final List<Populator> populators = new NonNullArrayList<Populator>();
    private final List<GenerationPopulator> genpopulator = Lists.newArrayList();
    private final List<GroundCoverLayer> groundcover = Lists.newArrayList();

    @Override
    public float getMinHeight() {
        return this.minHeight;
    }

    @Override
    public void setMinHeight(float height) {
        this.minHeight = height;
    }

    @Override
    public float getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void setMaxHeight(float height) {
        this.maxHeight = height;
    }

    @Override
    public List<GroundCoverLayer> getGroundCoverLayers() {
        return this.groundcover;
    }

    @Override
    public List<GenerationPopulator> getGenerationPopulators() {
        return this.genpopulator;
    }

    @Override
    public List<GenerationPopulator> getGenerationPopulators(Class<? extends GenerationPopulator> type) {
        return this.genpopulator.stream().filter(p -> type.isAssignableFrom(p.getClass())).collect(Collectors.toList());
    }

    @Override
    public List<Populator> getPopulators() {
        return this.populators;
    }

    @Override
    public <T extends Populator> List<T> getPopulators(Class<T> type) {
        return this.populators.stream().filter(p -> type.isAssignableFrom(p.getClass())).collect(Collectors.toList());
    }

    @Override
    public BiomeGenerationSettings copy() {
        SpongeBiomeGenerationSettings settings = new SpongeBiomeGenerationSettings();
        settings.minHeight = this.minHeight;
        settings.maxHeight = this.maxHeight;
        settings.groundcover.addAll(this.groundcover);
        settings.populators.addAll(this.populators);
        settings.genpopulator.addAll(this.genpopulator);
        return settings;
    }
}

