/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.gen.populators.RandomBlockPopulator;

public class RandomBlockBuilder
implements RandomBlock.Builder {
    private BlockState block;
    private VariableAmount count;
    private VariableAmount height;
    private Predicate<Location<World>> target;

    public RandomBlockBuilder() {
        this.reset();
    }

    @Override
    public RandomBlock.Builder block(BlockState block) {
        this.block = (BlockState)Preconditions.checkNotNull((Object)block, (Object)"block");
        return this;
    }

    @Override
    public RandomBlock.Builder perChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        return this;
    }

    @Override
    public RandomBlock.Builder placementTarget(Predicate<Location<World>> target) {
        this.target = (Predicate)Preconditions.checkNotNull(target, (Object)"target");
        return this;
    }

    @Override
    public RandomBlock.Builder height(VariableAmount height) {
        this.height = (VariableAmount)Preconditions.checkNotNull((Object)height, (Object)"height");
        return this;
    }

    @Override
    public RandomBlock.Builder from(RandomBlock value) {
        return this.block(value.getBlock()).perChunk(value.getAttemptsPerChunk()).placementTarget(value.getPlacementTarget()).height(value.getHeightRange());
    }

    @Override
    public RandomBlock.Builder reset() {
        this.count = VariableAmount.fixed(64.0);
        this.height = VariableAmount.baseWithRandomAddition(0.0, 128.0);
        this.target = WorldGenConstants.CAVE_LIQUIDS;
        this.block = BlockTypes.WATER.getDefaultState();
        return this;
    }

    @Override
    public RandomBlock build() throws IllegalStateException {
        RandomBlockPopulator pop = new RandomBlockPopulator(this.block, this.count, this.height, this.target);
        return pop;
    }
}

