/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.SeaFloor;

public class SeaFloorPopulator
implements SeaFloor {
    private BlockState block;
    private VariableAmount radius;
    private VariableAmount count;
    private Predicate<BlockState> check;
    private VariableAmount depth;

    public SeaFloorPopulator(BlockState block, VariableAmount radius, VariableAmount count, VariableAmount depth, Predicate<BlockState> check) {
        this.block = (BlockState)Preconditions.checkNotNull((Object)block, (Object)"block");
        this.radius = (VariableAmount)Preconditions.checkNotNull((Object)radius, (Object)"radius");
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count, (Object)"count");
        this.check = (Predicate)Preconditions.checkNotNull(check, (Object)"check");
        this.depth = (VariableAmount)Preconditions.checkNotNull((Object)depth, (Object)"depth");
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.SEA_FLOOR;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        int n = this.count.getFlooredAmount(random);
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        for (int i = 0; i < n; ++i) {
            BlockPos pos = position.func_177982_a(random.nextInt(size.getX()), 0, random.nextInt(size.getZ()));
            if (world.func_180495_p(pos = world.func_175672_r(pos)).func_185904_a() != Material.field_151586_h) continue;
            int radius = this.radius.getFlooredAmount(random);
            int depth = this.depth.getFlooredAmount(random);
            for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
                int x0 = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                    int z0 = z - pos.func_177952_p();
                    if (x0 * x0 + z0 * z0 > radius * radius) continue;
                    for (int y = pos.func_177956_o() - depth; y <= pos.func_177956_o() + depth; ++y) {
                        BlockPos blockpos1 = new BlockPos(x, y, z);
                        if (!this.check.test((BlockState)world.func_180495_p(blockpos1))) continue;
                        world.func_180501_a(blockpos1, (IBlockState)this.block, 2);
                    }
                }
            }
        }
    }

    @Override
    public BlockState getBlock() {
        return this.block;
    }

    @Override
    public void setBlock(BlockState block) {
        this.block = block;
    }

    @Override
    public VariableAmount getDiscsPerChunk() {
        return this.count;
    }

    @Override
    public void setDiscsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public VariableAmount getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(VariableAmount radius) {
        this.radius = radius;
    }

    @Override
    public Predicate<BlockState> getValidBlocksToReplace() {
        return this.check;
    }

    @Override
    public void setValidBlocksToReplace(Predicate<BlockState> check) {
        this.check = check;
    }

    @Override
    public VariableAmount getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(VariableAmount depth) {
        this.depth = depth;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("depth", (Object)this.depth).add("radius", (Object)this.radius).add("block", (Object)this.block.getType().getName()).add("count", (Object)this.count).toString();
    }
}

