/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.common.util.gen.AbstractBlockBuffer;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;

public class SpongeArchetypeVolume
extends AbstractBlockBuffer
implements ArchetypeVolume {
    private final MutableBlockVolume backing;
    private final Map<Vector3i, TileEntityArchetype> tiles;

    public SpongeArchetypeVolume(MutableBlockVolume backing, Map<Vector3i, TileEntityArchetype> tiles) {
        super(backing.getBlockMin(), backing.getBlockSize());
        this.backing = backing;
        this.tiles = Maps.newHashMap(tiles);
    }

    @Override
    public BlockPalette getPalette() {
        return ((AbstractBlockBuffer)((Object)this.backing)).getPalette();
    }

    @Override
    public Optional<TileEntityArchetype> getTileEntityArchetype(int x, int y, int z) {
        return Optional.ofNullable(this.tiles.get(this.getBlockMin().add(x, y, z)));
    }

    @Override
    public Map<Vector3i, TileEntityArchetype> getTileEntityArchetypes() {
        return this.tiles;
    }

    @Override
    public MutableBlockVolumeWorker<? extends ArchetypeVolume> getBlockWorker(Cause cause) {
        return new SpongeMutableBlockVolumeWorker<SpongeArchetypeVolume>(this, cause);
    }

    @Override
    public void apply(Location<World> location, BlockChangeFlag changeFlag, Cause cause) {
        this.backing.getBlockWorker(cause).iterate((v, x, y, z) -> ((World)location.getExtent()).setBlock(x + location.getBlockX(), y + location.getBlockY(), z + location.getBlockZ(), v.getBlock(x, y, z), changeFlag, cause));
        for (Vector3i pos : this.tiles.keySet()) {
            TileEntityArchetype archetype = this.tiles.get(pos);
            archetype.apply(location.add(pos), cause);
        }
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block, Cause cause) {
        this.backing.setBlock(x, y, z, block, cause);
        return true;
    }

    @Override
    public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        return this.backing.getBlockView(newMin, newMax);
    }

    @Override
    public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return this.backing.getBlockView(transform);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.backing.getBlock(x, y, z);
    }

    @Override
    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return this.backing.getUnmodifiableBlockView();
    }

    @Override
    public MutableBlockVolume getBlockCopy(StorageType type) {
        return this.backing.getBlockCopy(type);
    }

    @Override
    public ImmutableBlockVolume getImmutableBlockCopy() {
        return this.backing.getImmutableBlockCopy();
    }

    public MutableBlockVolume getBacking() {
        return this.backing;
    }
}

