/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.Optional;
import java.util.UUID;
import joptsimple.OptionSet;
import net.minecraft.init.Bootstrap;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.datafix.DataFixesManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.sql.SqlService;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeInternalListeners;
import org.spongepowered.common.entity.ai.SpongeEntityAICommonSuperclass;
import org.spongepowered.common.inject.SpongeGuice;
import org.spongepowered.common.inject.SpongeModule;
import org.spongepowered.common.interfaces.IMixinServerCommandManager;
import org.spongepowered.common.network.message.SpongeMessageHandler;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.service.permission.SpongeContextCalculator;
import org.spongepowered.common.service.permission.SpongePermissionService;
import org.spongepowered.common.service.sql.SqlServiceImpl;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;
import org.spongepowered.server.inject.SpongeVanillaModule;
import org.spongepowered.server.launch.VanillaCommandLine;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.plugin.PluginSource;
import org.spongepowered.server.plugin.MetaPluginContainer;
import org.spongepowered.server.plugin.MetadataContainer;
import org.spongepowered.server.plugin.MinecraftPluginContainer;
import org.spongepowered.server.plugin.VanillaPluginManager;

@Singleton
public final class SpongeVanilla
extends MetaPluginContainer {
    private final Logger logger;
    private final Game game;
    private final Cause gameCause;
    private final SpongeGameRegistry registry;

    @Inject
    public SpongeVanilla(MetadataContainer metadata, Logger logger, Game game, SpongeGameRegistry registry) {
        super(metadata.get("sponge", "SpongeVanilla"), PluginSource.find(SpongeVanilla.class));
        this.logger = logger;
        this.game = game;
        this.gameCause = Cause.of(NamedCause.source(game));
        this.registry = registry;
        this.logger.info("This server is running {} version {}", new Object[]{this.getName(), this.getVersion().orElse("unknown")});
    }

    public void preInitialize() throws Exception {
        this.logger.info("Loading Sponge...");
        this.registry.preRegistryInit();
        this.game.getEventManager().registerListeners(this, SpongeInternalListeners.getInstance());
        SpongeBootstrap.initializeServices();
        SpongeBootstrap.initializeCommands();
        this.logger.info("Loading plugins...");
        ((VanillaPluginManager)this.game.getPluginManager()).loadPlugins();
        SpongeImpl.postState(GameState.CONSTRUCTION, SpongeEventFactory.createGameConstructionEvent(this.gameCause));
        this.logger.info("Initializing plugins...");
        SpongeImpl.postState(GameState.PRE_INITIALIZATION, SpongeEventFactory.createGamePreInitializationEvent(this.gameCause));
        this.registry.preInit();
        Preconditions.checkState((boolean)Class.forName("org.spongepowered.api.entity.ai.task.AbstractAITask").getSuperclass().equals(SpongeEntityAICommonSuperclass.class));
        SpongeInternalListeners.getInstance().registerServiceCallback(PermissionService.class, input -> input.registerContextCalculator(new SpongeContextCalculator()));
        SpongeHooks.enableThreadContentionMonitoring();
        SpongeMessageHandler.init();
    }

    public void initialize() {
        this.registry.init();
        if (!this.game.getServiceManager().provide(PermissionService.class).isPresent()) {
            SpongePermissionService service = new SpongePermissionService(this.game);
            service.getGroupForOpLevel(1).getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.selector", Tristate.TRUE);
            service.getGroupForOpLevel(2).getSubjectData().setPermission(SubjectData.GLOBAL_CONTEXT, "minecraft.commandblock", Tristate.TRUE);
            this.game.getServiceManager().setProvider(this, PermissionService.class, service);
        }
        SpongeImpl.postState(GameState.INITIALIZATION, SpongeEventFactory.createGameInitializationEvent(this.gameCause));
        this.registry.postInit();
        SpongeImpl.postState(GameState.POST_INITIALIZATION, SpongeEventFactory.createGamePostInitializationEvent(this.gameCause));
        this.logger.info("Successfully loaded and initialized plugins.");
        SpongeImpl.postState(GameState.LOAD_COMPLETE, SpongeEventFactory.createGameLoadCompleteEvent(this.gameCause));
    }

    public void onServerAboutToStart() {
        ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerEarlyCommands(this.game);
        SpongeImpl.postState(GameState.SERVER_ABOUT_TO_START, SpongeEventFactory.createGameAboutToStartServerEvent(this.gameCause));
    }

    public void onServerStarting() {
        SpongeImpl.postState(GameState.SERVER_STARTING, SpongeEventFactory.createGameStartingServerEvent(this.gameCause));
        SpongeImpl.postState(GameState.SERVER_STARTED, SpongeEventFactory.createGameStartedServerEvent(this.gameCause));
        ((IMixinServerCommandManager)SpongeImpl.getServer().func_71187_D()).registerLowPriorityCommands(this.game);
        SpongePlayerDataHandler.init();
    }

    public void onServerStopping() {
        SpongeImpl.postState(GameState.SERVER_STOPPING, SpongeEventFactory.createGameStoppingServerEvent(this.gameCause));
    }

    public void onServerStopped() throws IOException {
        SpongeImpl.postState(GameState.SERVER_STOPPED, SpongeEventFactory.createGameStoppedServerEvent(this.gameCause));
        ((SqlServiceImpl)this.game.getServiceManager().provideUnchecked(SqlService.class)).close();
    }

    @Override
    public Optional<?> getInstance() {
        return Optional.of(this);
    }

    private static void start(String[] args) {
        MetadataContainer metadata = MetadataContainer.load();
        MinecraftPluginContainer.register();
        OptionSet options = VanillaCommandLine.parse(args);
        Bootstrap.func_151354_b();
        File worldDir = options.has(VanillaCommandLine.WORLD_DIR) ? options.valueOf(VanillaCommandLine.WORLD_DIR) : new File(".");
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
        MinecraftSessionService sessionService = authenticationService.createMinecraftSessionService();
        GameProfileRepository profileRepository = authenticationService.createProfileRepository();
        PlayerProfileCache profileCache = new PlayerProfileCache(profileRepository, new File(worldDir, MinecraftServer.field_152367_a.getName()));
        DedicatedServer server = new DedicatedServer(worldDir, DataFixesManager.func_188279_a(), authenticationService, sessionService, profileRepository, profileCache);
        NetHandlerPlayServer.class.getName();
        Stage stage = SpongeGuice.getInjectorStage(VanillaLaunch.ENVIRONMENT == VanillaLaunch.Environment.DEVELOPMENT ? Stage.DEVELOPMENT : Stage.PRODUCTION);
        SpongeImpl.getLogger().debug("Creating injector in stage '{}'", new Object[]{stage});
        Guice.createInjector(stage, new SpongeModule(), new SpongeVanillaModule((MinecraftServer)server, metadata));
        if (options.has(VanillaCommandLine.WORLD_NAME)) {
            server.func_71261_m(options.valueOf(VanillaCommandLine.WORLD_NAME));
        }
        if (options.has(VanillaCommandLine.PORT)) {
            server.func_71208_b(options.valueOf(VanillaCommandLine.PORT).intValue());
        }
        if (options.has(VanillaCommandLine.BONUS_CHEST)) {
            server.func_71194_c(true);
        }
        server.func_71256_s();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((DedicatedServer)server).func_71260_j(), "Server Shutdown Thread"));
    }

    public static void main(String[] args) {
        try {
            SpongeVanilla.start(args);
        }
        catch (Exception e) {
            SpongeImpl.getLogger().fatal("Failed to start the Minecraft server", (Throwable)e);
            System.exit(1);
        }
    }
}

