/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.console;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.dedicated.DedicatedServer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.spongepowered.common.SpongeImpl;

public final class ConsoleCommandCompleter
implements Completer {
    private final DedicatedServer server;

    public ConsoleCommandCompleter(DedicatedServer server) {
        this.server = (DedicatedServer)Preconditions.checkNotNull((Object)server, (Object)"server");
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        boolean prefix;
        String buffer = line.line();
        if (buffer.isEmpty() || buffer.charAt(0) != '/') {
            buffer = '/' + buffer;
            prefix = false;
        } else {
            prefix = true;
        }
        String input = buffer;
        ListenableFuture tabComplete = this.server.func_175586_a(() -> this.server.func_184104_a((ICommandSender)this.server, input, this.server.func_180425_c(), false));
        try {
            for (String completion : (List)tabComplete.get()) {
                if (completion.isEmpty()) continue;
                candidates.add(new Candidate(prefix || completion.charAt(0) != '/' ? completion : completion.substring(1)));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            SpongeImpl.getLogger().error("Failed to tab complete", (Throwable)e);
        }
    }
}

