/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.console;

import java.util.function.Function;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.common.text.serializer.LegacyTexts;

public final class ConsoleFormatter
implements Function<String, String> {
    public static final ConsoleFormatter INSTANCE = new ConsoleFormatter();
    private static final String RESET = "\u001b[39;0m";
    private static final String[] ansi = new String[LegacyTexts.getFormattingCount()];

    private static void map(TextFormatting formatting, String ansiMapping) {
        ConsoleFormatter.ansi[formatting.ordinal()] = ansiMapping;
    }

    private ConsoleFormatter() {
    }

    @Override
    public String apply(String text) {
        int next = text.indexOf(167);
        int last = text.length() - 1;
        if (next == -1 || next == last) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() + 20);
        int pos = 0;
        do {
            if (pos != next) {
                result.append(text, pos, next);
            }
            pos = next;
            int format = LegacyTexts.findFormat(text.charAt(next + 1));
            if (format != -1) {
                result.append(ansi[format]);
                pos = next += 2;
                continue;
            }
            ++next;
        } while ((next = text.indexOf(167, next)) != -1 && next < last);
        return result.append(text, pos, text.length()).append(RESET).toString();
    }

    static {
        ConsoleFormatter.map(TextFormatting.BLACK, "\u001b[0;30;22m");
        ConsoleFormatter.map(TextFormatting.DARK_BLUE, "\u001b[0;34;22m");
        ConsoleFormatter.map(TextFormatting.DARK_GREEN, "\u001b[0;32;22m");
        ConsoleFormatter.map(TextFormatting.DARK_AQUA, "\u001b[0;36;22m");
        ConsoleFormatter.map(TextFormatting.DARK_RED, "\u001b[0;31;22m");
        ConsoleFormatter.map(TextFormatting.DARK_PURPLE, "\u001b[0;35;22m");
        ConsoleFormatter.map(TextFormatting.GOLD, "\u001b[0;33;22m");
        ConsoleFormatter.map(TextFormatting.GRAY, "\u001b[0;37;22m");
        ConsoleFormatter.map(TextFormatting.DARK_GRAY, "\u001b[0;30;1m");
        ConsoleFormatter.map(TextFormatting.BLUE, "\u001b[0;34;1m");
        ConsoleFormatter.map(TextFormatting.GREEN, "\u001b[0;32;1m");
        ConsoleFormatter.map(TextFormatting.AQUA, "\u001b[0;36;1m");
        ConsoleFormatter.map(TextFormatting.RED, "\u001b[0;31;1m");
        ConsoleFormatter.map(TextFormatting.LIGHT_PURPLE, "\u001b[0;35;1m");
        ConsoleFormatter.map(TextFormatting.YELLOW, "\u001b[0;33;1m");
        ConsoleFormatter.map(TextFormatting.WHITE, "\u001b[0;37;1m");
        ConsoleFormatter.map(TextFormatting.OBFUSCATED, "\u001b[5m");
        ConsoleFormatter.map(TextFormatting.BOLD, "\u001b[21m");
        ConsoleFormatter.map(TextFormatting.STRIKETHROUGH, "\u001b[9m");
        ConsoleFormatter.map(TextFormatting.UNDERLINE, "\u001b[4m");
        ConsoleFormatter.map(TextFormatting.ITALIC, "\u001b[3m");
        ConsoleFormatter.map(TextFormatting.RESET, RESET);
    }
}

