/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.console;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final ImmutableSet<String> IGNORED_CLASSES = ImmutableSet.of((Object)"org.spongepowered.asm.util.PrettyPrinter");
    private static final String[] ignoredPackages = new String[]{"java.", "sun.", "kotlin.io."};
    private final PrintStream out;
    @Nullable
    private final String fqcn;
    private final Logger logger;
    private final Level level;
    boolean flush = true;

    public LoggingOutputStream(PrintStream out, Logger logger, Level level, @Nullable String fqcn) {
        this.out = (PrintStream)Preconditions.checkNotNull((Object)out, (Object)"out");
        this.fqcn = fqcn;
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (Object)"logger");
        this.level = (Level)Preconditions.checkNotNull((Object)level, (Object)"level");
    }

    @Override
    public void flush() throws IOException {
        if (!this.flush) {
            return;
        }
        String message = this.toString();
        this.reset();
        if (!message.isEmpty() && !message.equals(SEPARATOR)) {
            if (message.endsWith(SEPARATOR)) {
                message = message.substring(0, message.length() - SEPARATOR.length());
            }
            if (message.charAt(message.length() - 1) == '\n') {
                message = message.substring(0, message.length() - 1);
            }
            if (this.logger.isEnabled(this.level)) {
                StackTraceElement location;
                if (this.fqcn != null && (location = LoggingOutputStream.calculateLocation(this.fqcn)) != null) {
                    if (IGNORED_CLASSES.contains((Object)location.getClassName())) {
                        this.out.println(message);
                    } else {
                        this.logger.log(this.level, "[" + location + "]: " + message);
                    }
                    return;
                }
                this.logger.log(this.level, message);
            }
        }
    }

    private static StackTraceElement calculateLocation(String fqcn) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement last = null;
        for (int i = stackTrace.length - 1; i > 0; --i) {
            String className = stackTrace[i].getClassName();
            if (fqcn.equals(className)) {
                return last;
            }
            if (className.equals("java.lang.Throwable") && stackTrace[i].getMethodName().equals("printStackTrace")) {
                return null;
            }
            boolean isIgnored = false;
            for (String ignored : ignoredPackages) {
                if (!className.startsWith(ignored)) continue;
                isIgnored = true;
                break;
            }
            if (isIgnored) continue;
            last = stackTrace[i];
        }
        return null;
    }
}

