/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.console;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Booleans;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

@Plugin(name="TerminalConsole", category="Core", elementType="appender", printObject=true)
public final class TerminalConsoleAppender
extends AbstractAppender {
    public static final String ANSI_RESET = "\u001b[39;0m";
    private static final String ANSI_ERROR = "\u001b[31;1m";
    private static final String ANSI_WARN = "\u001b[33;1m";
    private static final PrintStream out = System.out;
    private static boolean initialized;
    @Nullable
    private static Terminal terminal;
    @Nullable
    private static LineReader reader;
    private static Function<String, String> formatter;

    @Nullable
    public static Terminal getTerminal() {
        return terminal;
    }

    @Nullable
    public static LineReader getReader() {
        return reader;
    }

    public static void setReader(@Nullable LineReader newReader) {
        if (newReader != null && newReader.getTerminal() != terminal) {
            throw new IllegalArgumentException("Reader was not created with TerminalConsoleAppender.getTerminal()");
        }
        reader = newReader;
    }

    public static void setFormatter(@Nullable Function<String, String> format) {
        formatter = format != null ? format : Function.identity();
    }

    private TerminalConsoleAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        TerminalConsoleAppender.initialize();
    }

    @PluginFactory
    public static TerminalConsoleAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") @Nullable Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions") String ignore) {
        if (name == null) {
            LOGGER.error("No name provided for TerminalConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null, null);
        }
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        return new TerminalConsoleAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions);
    }

    private static void initialize() {
        if (!initialized) {
            initialized = true;
            if (PropertiesUtil.getProperties().getBooleanProperty("jline.enable", true) && System.getProperty("FORGE_FORCE_FRAME_RECALC") == null) {
                try {
                    terminal = TerminalBuilder.builder().dumb(true).build();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to initialize terminal. Falling back to standard output", (Throwable)e);
                }
            } else {
                LOGGER.warn("Disabling terminal, you're running in an unsupported environment.");
            }
        }
    }

    public void append(LogEvent event) {
        if (terminal != null) {
            if (reader != null) {
                reader.callWidget("clear");
                terminal.writer().print(this.formatEvent(event));
                reader.callWidget("redraw-line");
                reader.callWidget("redisplay");
            } else {
                terminal.writer().print(this.formatEvent(event));
            }
            terminal.writer().flush();
        } else {
            out.print(this.formatEvent(event));
        }
    }

    private String formatEvent(LogEvent event) {
        String formatted = formatter.apply(this.getLayout().toSerializable(event).toString());
        if (terminal != null) {
            int level = event.getLevel().intLevel();
            if (level <= Level.ERROR.intLevel()) {
                return ANSI_ERROR + formatted + ANSI_RESET;
            }
            if (level <= Level.WARN.intLevel()) {
                return ANSI_WARN + formatted + ANSI_RESET;
            }
        }
        return formatted;
    }

    static {
        formatter = Function.identity();
    }
}

