/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.world.chunkio;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;

public final class AsyncAnvilChunkLoader {
    private AsyncAnvilChunkLoader() {
    }

    public static NBTTagCompound read(AnvilChunkLoader loader, int x, int z) throws IOException {
        ChunkPos chunkpos = new ChunkPos(x, z);
        NBTTagCompound nbttagcompound = (NBTTagCompound)loader.field_75828_a.get(chunkpos);
        if (nbttagcompound == null) {
            DataInputStream datainputstream = RegionFileCache.func_76549_c((File)loader.field_75825_d, (int)x, (int)z);
            if (datainputstream == null) {
                return null;
            }
            nbttagcompound = loader.field_186055_e.func_188257_a((IFixType)FixTypes.CHUNK, CompressedStreamTools.func_74794_a((DataInputStream)datainputstream));
        }
        return nbttagcompound;
    }

    public static void loadEntities(World worldIn, Chunk chunk, NBTTagCompound compound) {
        compound = compound.func_74775_l("Level");
        NBTTagList nbttaglist1 = compound.func_150295_c("Entities", 10);
        for (int j1 = 0; j1 < nbttaglist1.func_74745_c(); ++j1) {
            NBTTagCompound nbttagcompound1 = nbttaglist1.func_150305_b(j1);
            AnvilChunkLoader.func_186050_a((NBTTagCompound)nbttagcompound1, (World)worldIn, (Chunk)chunk);
            chunk.func_177409_g(true);
        }
        NBTTagList nbttaglist2 = compound.func_150295_c("TileEntities", 10);
        for (int k1 = 0; k1 < nbttaglist2.func_74745_c(); ++k1) {
            NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(k1);
            TileEntity tileentity = TileEntity.func_190200_a((World)worldIn, (NBTTagCompound)nbttagcompound2);
            if (tileentity == null) continue;
            chunk.func_150813_a(tileentity);
        }
        if (compound.func_150297_b("TileTicks", 9)) {
            NBTTagList nbttaglist3 = compound.func_150295_c("TileTicks", 10);
            for (int l1 = 0; l1 < nbttaglist3.func_74745_c(); ++l1) {
                NBTTagCompound nbttagcompound3 = nbttaglist3.func_150305_b(l1);
                Block block = nbttagcompound3.func_150297_b("i", 8) ? Block.func_149684_b((String)nbttagcompound3.func_74779_i("i")) : Block.func_149729_e((int)nbttagcompound3.func_74762_e("i"));
                worldIn.func_180497_b(new BlockPos(nbttagcompound3.func_74762_e("x"), nbttagcompound3.func_74762_e("y"), nbttagcompound3.func_74762_e("z")), block, nbttagcompound3.func_74762_e("t"), nbttagcompound3.func_74762_e("p"));
            }
        }
    }
}

