/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.key;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.data.value.mutable.SetValue;

public final class KeyFactory {
    private KeyFactory() {
    }

    public static <E, V extends BaseValue<E>> Key<V> makeSingleKey(final TypeToken<E> elementToken, final TypeToken<V> valueToken, final DataQuery query, final String id, final String name) {
        KeyFactory.validateId(id);
        return new Key<V>(){
            @Nullable
            private String string;
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{elementToken, valueToken, query});
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public TypeToken<V> getValueToken() {
                return valueToken;
            }

            @Override
            public TypeToken<?> getElementToken() {
                return elementToken;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                if (this.string == null) {
                    this.string = "Key{Value:" + valueToken.getRawType().getSimpleName() + "<" + elementToken.getRawType().getSimpleName() + ">, Query: " + query.toString() + "}";
                }
                return this.string;
            }
        };
    }

    public static <E> Key<ListValue<E>> makeListKey(final TypeToken<? extends List<E>> elementToken, final TypeToken<ListValue<E>> valueToken, final DataQuery query, final String id, final String name) {
        KeyFactory.validateId(id);
        return new Key<ListValue<E>>(){
            @Nullable
            private String string;
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{ListValue.class, elementToken, query});
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public TypeToken<ListValue<E>> getValueToken() {
                return valueToken;
            }

            @Override
            public TypeToken<?> getElementToken() {
                return elementToken;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                if (this.string == null) {
                    this.string = "Key{Value:ListValue<" + elementToken.toString() + ">, Query: " + query.toString() + "}";
                }
                return this.string;
            }
        };
    }

    public static <E> Key<SetValue<E>> makeSetKey(final TypeToken<? extends Set<E>> elementToken, final TypeToken<SetValue<E>> valueToken, final DataQuery query, final String id, final String name) {
        KeyFactory.validateId(id);
        return new Key<SetValue<E>>(){
            @Nullable
            private String string;
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{ListValue.class, elementToken, query});
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public TypeToken<SetValue<E>> getValueToken() {
                return valueToken;
            }

            @Override
            public TypeToken<?> getElementToken() {
                return elementToken;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                if (this.string == null) {
                    this.string = "Key{Value:SetValue<" + elementToken.toString() + ">, Query: " + query.toString() + "}";
                }
                return this.string;
            }
        };
    }

    public static <K, V> Key<MapValue<K, V>> makeMapKey(final TypeToken<Map<K, V>> elementToken, final TypeToken<MapValue<K, V>> valueToken, final DataQuery query, final String id, final String name) {
        KeyFactory.validateId(id);
        return new Key<MapValue<K, V>>(){
            @Nullable
            private String string;
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{elementToken, valueToken, query});
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public TypeToken<MapValue<K, V>> getValueToken() {
                return valueToken;
            }

            @Override
            public TypeToken<?> getElementToken() {
                return elementToken;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                if (this.string == null) {
                    this.string = "Key{Value:MapValue<" + elementToken.toString() + "," + valueToken.toString() + ">, Query: " + query.toString() + "}";
                }
                return this.string;
            }
        };
    }

    public static <E> Key<OptionalValue<E>> makeOptionalKey(final TypeToken<Optional<E>> elementToken, final TypeToken<OptionalValue<E>> valueToken, final DataQuery query, final String id, final String name) {
        KeyFactory.validateId(id);
        return new Key<OptionalValue<E>>(){
            @Nullable
            private String string;
            private final int hash;
            {
                this.hash = Objects.hashCode((Object[])new Object[]{Optional.class, elementToken, query});
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public TypeToken<OptionalValue<E>> getValueToken() {
                return valueToken;
            }

            @Override
            public TypeToken<?> getElementToken() {
                return elementToken;
            }

            @Override
            public DataQuery getQuery() {
                return query;
            }

            public int hashCode() {
                return this.hash;
            }

            public String toString() {
                if (this.string == null) {
                    this.string = "Key{Value:OptionalValue<" + elementToken.toString() + ">, Query: " + query.toString() + "}";
                }
                return this.string;
            }
        };
    }

    private static void validateId(String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"A Key's id cannot be null!");
        Preconditions.checkArgument((boolean)id.contains(":"), (Object)"A key must have a plugin id prefix with \":\" separating the plugin id and key id!");
    }

    static <E, V extends BaseValue<E>> Key<V> fake(final String keyName) {
        return new Key<V>(){

            @Override
            public String getId() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }

            @Override
            public String getName() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }

            @Override
            public TypeToken<V> getValueToken() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }

            @Override
            public TypeToken<?> getElementToken() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }

            @Override
            public DataQuery getQuery() {
                throw new UnsupportedOperationException("Key " + keyName + " is not implemented");
            }
        };
    }
}

