/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableVariantData;
import org.spongepowered.api.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.api.data.manipulator.mutable.VariantData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;

public abstract class AbstractImmutableSingleCatalogData<E extends CatalogType, I extends ImmutableVariantData<E, I, M>, M extends VariantData<E, M, I>>
extends AbstractImmutableSingleData<E, I, M>
implements ImmutableVariantData<E, I, M> {
    private final E defaultValue;
    private final ImmutableValue<E> immutableValue;

    protected AbstractImmutableSingleCatalogData(E value, E defaultValue, Key<? extends BaseValue<E>> usedKey) {
        super(value, usedKey);
        this.defaultValue = (CatalogType)Preconditions.checkNotNull(defaultValue, (Object)"The default value was null! This is unacceptable! Maybe the value was not registered?");
        this.immutableValue = Sponge.getRegistry().getValueFactory().createValue(this.usedKey, this.defaultValue, this.value).asImmutable();
    }

    @Override
    protected ImmutableValue<E> getValueGetter() {
        return this.immutableValue;
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), (Object)((CatalogType)this.value).getId());
    }

    @Override
    public ImmutableValue<E> type() {
        return this.immutableValue;
    }
}

