/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.extra.modifier.skylands;

import java.util.List;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.extra.modifier.skylands.SkylandsBiomeGenerator;
import org.spongepowered.api.extra.modifier.skylands.SkylandsGrassPopulator;
import org.spongepowered.api.extra.modifier.skylands.SkylandsGroundCoverPopulator;
import org.spongepowered.api.extra.modifier.skylands.SkylandsTerrainGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Lake;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.api.world.storage.WorldProperties;

public class SkylandsWorldGeneratorModifier
implements WorldGeneratorModifier {
    @Override
    public void modifyWorldGenerator(WorldProperties properties, DataContainer settings, WorldGenerator worldGenerator) {
        worldGenerator.setBaseGenerationPopulator(new SkylandsTerrainGenerator());
        worldGenerator.setBiomeGenerator(new SkylandsBiomeGenerator());
        List<GenerationPopulator> generationPopulators = worldGenerator.getGenerationPopulators();
        generationPopulators.clear();
        generationPopulators.add(new SkylandsGroundCoverPopulator());
        generationPopulators.add(new SkylandsGrassPopulator());
        worldGenerator.getPopulators().clear();
        Forest forest = Forest.builder().perChunk(VariableAmount.baseWithOptionalAddition(6.0, 1.0, 0.1)).type(BiomeTreeTypes.OAK.getPopulatorObject(), 4.0).type(BiomeTreeTypes.BIRCH.getPopulatorObject(), 1.0).build();
        worldGenerator.getPopulators().add(0, forest);
        Lake lake = Lake.builder().chance(0.25).liquidType(BlockTypes.WATER.getDefaultState()).height(VariableAmount.baseWithRandomAddition(0.0, 256.0)).build();
        worldGenerator.getPopulators().add(1, lake);
    }

    @Override
    public String getId() {
        return "sponge:skylands";
    }

    @Override
    public String getName() {
        return "Skylands Modifier";
    }
}

