/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.selector;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.text.selector.Argument;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.text.selector.ArgumentTypes;
import org.spongepowered.api.text.selector.SelectorType;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public interface Selector {
    public static Builder builder() {
        return ArgumentTypes.getFactory().createBuilder();
    }

    public static Selector parse(String selector) {
        return ArgumentTypes.getFactory().parseRawSelector(selector);
    }

    public static List<String> complete(String selector) {
        return ArgumentTypes.getFactory().complete(selector);
    }

    public SelectorType getType();

    public <T> Optional<T> get(ArgumentType<T> var1);

    public <T> Optional<Argument<T>> getArgument(ArgumentType<T> var1);

    public <T> Optional<Argument.Invertible<T>> getArgument(ArgumentType.Invertible<T> var1);

    public List<Argument<?>> getArguments();

    public boolean has(ArgumentType<?> var1);

    public boolean isInverted(ArgumentType.Invertible<?> var1);

    public Set<Entity> resolve(CommandSource var1);

    public Set<Entity> resolve(Extent ... var1);

    public Set<Entity> resolve(Collection<? extends Extent> var1);

    public Set<Entity> resolve(Location<World> var1);

    public Set<Entity> resolveForce(CommandSource var1);

    public Set<Entity> resolveForce(Extent ... var1);

    public Set<Entity> resolveForce(Collection<? extends Extent> var1);

    public Set<Entity> resolveForce(Location<World> var1);

    public String toPlain();

    public Builder toBuilder();

    public static interface Builder
    extends ResettableBuilder<Selector, Builder> {
        public Builder type(SelectorType var1);

        public Builder add(Argument<?> ... var1);

        public Builder add(Iterable<Argument<?>> var1);

        public <T> Builder add(ArgumentType<T> var1, T var2);

        public Builder remove(Argument<?> ... var1);

        public Builder remove(Iterable<Argument<?>> var1);

        public Builder remove(ArgumentType<?> ... var1);

        public Selector build();
    }
}

