/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Functional {
    private Functional() {
    }

    @SafeVarargs
    public static <E> Predicate<E> predicateAnd(Predicate<E> ... predicates) {
        return Functional.predicateAnd(Arrays.asList(predicates));
    }

    public static <E> Predicate<E> predicateAnd(Iterable<Predicate<E>> predicates) {
        return e -> {
            for (Predicate pred : predicates) {
                if (pred.test(e)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    public static <L, R> BiPredicate<L, R> biPredicateAnd(BiPredicate<L, R> ... predicates) {
        return Functional.biPredicateAnd(Arrays.asList(predicates));
    }

    public static <L, R> BiPredicate<L, R> biPredicateAnd(Iterable<BiPredicate<L, R>> predicates) {
        return (l, r) -> {
            for (BiPredicate pred : predicates) {
                if (pred.test(l, r)) continue;
                return false;
            }
            return true;
        };
    }

    public static <E> Predicate<E> predicateIn(Collection<E> collection) {
        return collection::contains;
    }

    public static <E> com.google.common.base.Predicate<E> java8ToGuava(Predicate<E> predicate) {
        return predicate::test;
    }

    @Deprecated
    public static <E> Predicate<E> guavaToJava8(com.google.common.base.Predicate<E> p) {
        return p;
    }

    public static <T> Set<T> optionalAsSet(Optional<T> value) {
        return value.isPresent() ? ImmutableSet.of(value.get()) : ImmutableSet.of();
    }

    public static <T> CompletableFuture<T> failableFuture(Callable<T> call) {
        CompletableFuture<T> ret = new CompletableFuture<T>();
        try {
            ret.complete(call.call());
        }
        catch (Exception e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }

    public static <T> CompletableFuture<T> asyncFailableFuture(Callable<T> call, Executor exec) {
        CompletableFuture ret = new CompletableFuture();
        exec.execute(() -> {
            try {
                ret.complete(call.call());
            }
            catch (Exception e) {
                ret.completeExceptionally(e);
            }
        });
        return ret;
    }
}

