/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.launchwrapper;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;

public final class LaunchClassLoaderUtil {
    private static final Map<LaunchClassLoader, LaunchClassLoaderUtil> utils = new HashMap<LaunchClassLoader, LaunchClassLoaderUtil>();
    private final LaunchClassLoader classLoader;
    private Map<String, Class<?>> cachedClasses;
    private final Set<String> invalidClasses;
    private final Set<String> classLoaderExceptions;
    private final Set<String> transformerExceptions;

    private LaunchClassLoaderUtil(LaunchClassLoader classLoader) {
        this.classLoader = classLoader;
        this.cachedClasses = (Map)LaunchClassLoaderUtil.getField(classLoader, "cachedClasses");
        this.invalidClasses = (Set)LaunchClassLoaderUtil.getField(classLoader, "invalidClasses");
        this.classLoaderExceptions = (Set)LaunchClassLoaderUtil.getField(classLoader, "classLoaderExceptions");
        this.transformerExceptions = (Set)LaunchClassLoaderUtil.getField(classLoader, "transformerExceptions");
    }

    public LaunchClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<String> getLoadedClasses() {
        return this.getLoadedClasses(null);
    }

    public Set<String> getLoadedClasses(String filter) {
        HashSet<String> loadedClasses = new HashSet<String>();
        for (String className : this.cachedClasses.keySet()) {
            if (filter != null && !className.startsWith(filter)) continue;
            loadedClasses.add(className);
        }
        return loadedClasses;
    }

    public boolean isClassLoaded(String name) {
        return this.cachedClasses != null && this.cachedClasses.containsKey(name);
    }

    public boolean isClassExcluded(String name, String transformedName) {
        for (String exception : this.getClassLoaderExceptions()) {
            if (!transformedName.startsWith(exception) && !name.startsWith(exception)) continue;
            return true;
        }
        for (String exception : this.getTransformerExceptions()) {
            if (!transformedName.startsWith(exception) && !name.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    public void registerInvalidClass(String name) {
        if (this.invalidClasses != null) {
            this.invalidClasses.add(name);
        }
    }

    public Set<String> getClassLoaderExceptions() {
        if (this.classLoaderExceptions != null) {
            return this.classLoaderExceptions;
        }
        return Collections.emptySet();
    }

    public Set<String> getTransformerExceptions() {
        if (this.transformerExceptions != null) {
            return this.transformerExceptions;
        }
        return Collections.emptySet();
    }

    private static <T> T getField(LaunchClassLoader classLoader, String fieldName) {
        try {
            Field field = LaunchClassLoader.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(classLoader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static LaunchClassLoaderUtil forClassLoader(LaunchClassLoader classLoader) {
        LaunchClassLoaderUtil util = utils.get(classLoader);
        if (util == null) {
            util = new LaunchClassLoaderUtil(classLoader);
            utils.put(classLoader, util);
        }
        return util;
    }
}

