/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.DefaultObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.config.ConfigRoot;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfigRoot;
import org.spongepowered.common.plugin.PluginContainerExtension;

@Singleton
public class SpongeConfigManager
implements ConfigManager {
    @Override
    public ConfigRoot getSharedConfig(Object instance) {
        return SpongeConfigManager.getSharedRoot(this.containerFromInstance(instance));
    }

    @Override
    public ConfigRoot getPluginConfig(Object instance) {
        return SpongeConfigManager.getPrivateRoot(this.containerFromInstance(instance));
    }

    private PluginContainer containerFromInstance(Object instance) {
        Optional<PluginContainer> container = Sponge.getPluginManager().fromInstance(instance);
        if (container.isPresent()) {
            return container.get();
        }
        throw new IllegalArgumentException("No container available for instance " + instance + ", is this actually a plugin?");
    }

    public static ConfigRoot getSharedRoot(PluginContainer container) {
        String name = container.getId().toLowerCase();
        return new SpongeConfigRoot(SpongeConfigManager.getMapperFactory(container), name, SpongeImpl.getPluginConfigDir());
    }

    public static ConfigRoot getPrivateRoot(PluginContainer container) {
        String name = container.getId().toLowerCase();
        return new SpongeConfigRoot(SpongeConfigManager.getMapperFactory(container), name, SpongeImpl.getPluginConfigDir().resolve(name));
    }

    private static ObjectMapperFactory getMapperFactory(PluginContainer container) {
        Injector injector;
        if (container instanceof PluginContainerExtension && (injector = ((PluginContainerExtension)((Object)container)).getInjector()) != null) {
            return injector.getInstance(GuiceObjectMapperFactory.class);
        }
        return DefaultObjectMapperFactory.getInstance();
    }
}

