/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractImmutableBooleanData<I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
extends AbstractImmutableSingleData<Boolean, I, M> {
    private final Class<? extends M> mutableClass;
    private final boolean defaultValue;
    private final ImmutableValue<Boolean> immutableValue;

    public AbstractImmutableBooleanData(Class<I> immutableClass, boolean value, Key<? extends BaseValue<Boolean>> usedKey, Class<? extends M> mutableClass, boolean defaultValue) {
        super(immutableClass, value, usedKey);
        Preconditions.checkArgument((!Modifier.isAbstract(mutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(mutableClass.getModifiers()) ? 1 : 0) != 0, (Object)"The immutable class cannot be an interface!");
        this.mutableClass = (Class)Preconditions.checkNotNull(mutableClass);
        this.defaultValue = defaultValue;
        this.immutableValue = ImmutableSpongeValue.cachedOf(usedKey, defaultValue, value);
    }

    @Override
    protected final ImmutableValue<Boolean> getValueGetter() {
        return this.immutableValue;
    }

    @Override
    public M asMutable() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.mutableClass, this.getValue()));
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey, this.value);
    }
}

