/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableArmorStandData;
import org.spongepowered.api.data.manipulator.mutable.entity.ArmorStandData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeArmorStandData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeArmorStandData
extends AbstractImmutableData<ImmutableArmorStandData, ArmorStandData>
implements ImmutableArmorStandData {
    private final boolean marker;
    private final boolean small;
    private final boolean arms;
    private final boolean basePlate;
    private final ImmutableValue<Boolean> markerValue;
    private final ImmutableValue<Boolean> smallValue;
    private final ImmutableValue<Boolean> armsValue;
    private final ImmutableValue<Boolean> basePlateValue;

    public ImmutableSpongeArmorStandData() {
        this(false, false, false, true);
    }

    public ImmutableSpongeArmorStandData(boolean marker, boolean small, boolean arms, boolean basePlate) {
        super(ImmutableArmorStandData.class);
        this.marker = marker;
        this.small = small;
        this.arms = arms;
        this.basePlate = basePlate;
        this.markerValue = ImmutableSpongeValue.cachedOf(Keys.ARMOR_STAND_MARKER, false, this.marker);
        this.smallValue = ImmutableSpongeValue.cachedOf(Keys.ARMOR_STAND_IS_SMALL, false, this.small);
        this.armsValue = ImmutableSpongeValue.cachedOf(Keys.ARMOR_STAND_HAS_ARMS, false, this.arms);
        this.basePlateValue = ImmutableSpongeValue.cachedOf(Keys.ARMOR_STAND_HAS_BASE_PLATE, true, this.basePlate);
        this.registerGetters();
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.ARMOR_STAND_HAS_ARMS, () -> this.arms);
        this.registerKeyValue(Keys.ARMOR_STAND_HAS_ARMS, () -> this.armsValue);
        this.registerFieldGetter(Keys.ARMOR_STAND_IS_SMALL, () -> this.small);
        this.registerKeyValue(Keys.ARMOR_STAND_IS_SMALL, () -> this.smallValue);
        this.registerFieldGetter(Keys.ARMOR_STAND_HAS_BASE_PLATE, () -> this.basePlate);
        this.registerKeyValue(Keys.ARMOR_STAND_HAS_BASE_PLATE, () -> this.basePlateValue);
        this.registerFieldGetter(Keys.ARMOR_STAND_MARKER, () -> this.marker);
        this.registerKeyValue(Keys.ARMOR_STAND_MARKER, () -> this.markerValue);
    }

    @Override
    public ImmutableValue<Boolean> marker() {
        return this.markerValue;
    }

    @Override
    public ImmutableValue<Boolean> small() {
        return this.smallValue;
    }

    @Override
    public ImmutableValue<Boolean> arms() {
        return this.armsValue;
    }

    @Override
    public ImmutableValue<Boolean> basePlate() {
        return this.basePlateValue;
    }

    @Override
    public ArmorStandData asMutable() {
        return new SpongeArmorStandData(this.marker, this.small, this.arms, this.basePlate);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.ARMOR_STAND_HAS_ARMS, (Object)this.arms).set(Keys.ARMOR_STAND_HAS_BASE_PLATE, (Object)this.basePlate).set(Keys.ARMOR_STAND_IS_SMALL, (Object)this.small).set(Keys.ARMOR_STAND_MARKER, (Object)this.marker);
    }
}

