/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import net.minecraft.init.Blocks;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableMinecartBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.MinecartBlockData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeMinecartBlockData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeMinecartBlockData
extends AbstractData<MinecartBlockData, ImmutableMinecartBlockData>
implements MinecartBlockData {
    private BlockState block;
    private int offset;

    public SpongeMinecartBlockData() {
        this((BlockState)Blocks.field_150350_a.func_176223_P(), 6);
    }

    public SpongeMinecartBlockData(BlockState block, int offset) {
        super(MinecartBlockData.class);
        this.block = (BlockState)Preconditions.checkNotNull((Object)block);
        this.offset = offset;
        this.registerGettersAndSetters();
    }

    @Override
    public Value<BlockState> block() {
        return new SpongeValue<BlockState>(Keys.REPRESENTED_BLOCK, (BlockState)Blocks.field_150350_a.func_176223_P(), this.block);
    }

    @Override
    public Value<Integer> offset() {
        return new SpongeValue<Integer>(Keys.OFFSET, 6, this.offset);
    }

    @Override
    public MinecartBlockData copy() {
        return new SpongeMinecartBlockData(this.block, this.offset);
    }

    @Override
    public ImmutableMinecartBlockData asImmutable() {
        return new ImmutableSpongeMinecartBlockData(this.block, this.offset);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.REPRESENTED_BLOCK, (Object)this.block).set(Keys.OFFSET, (Object)this.offset);
    }

    public BlockState getBlock() {
        return this.block;
    }

    public void setBlock(BlockState block) {
        this.block = (BlockState)Preconditions.checkNotNull((Object)block);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerKeyValue(Keys.REPRESENTED_BLOCK, this::block);
        this.registerKeyValue(Keys.OFFSET, this::offset);
        this.registerFieldGetter(Keys.REPRESENTED_BLOCK, this::getBlock);
        this.registerFieldGetter(Keys.OFFSET, this::getOffset);
        this.registerFieldSetter(Keys.REPRESENTED_BLOCK, this::setBlock);
        this.registerFieldSetter(Keys.OFFSET, this::setOffset);
    }
}

