/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.SpongeEntityConstants;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.entity.SpongeHorseStyle;

public class HorseUtils {
    public static int getInternalVariant(SpongeHorseColor color, SpongeHorseStyle style) {
        return color.getBitMask() | style.getBitMask();
    }

    public static HorseColor getHorseColor(EntityHorse horse) {
        return SpongeEntityConstants.HORSE_COLOR_IDMAP.get(horse.func_110202_bQ() & 0xFF);
    }

    public static HorseColor getHorseColor(DataView container) {
        return SpongeImpl.getRegistry().getType(HorseColor.class, DataUtil.getData(container, Keys.HORSE_COLOR, String.class)).get();
    }

    public static HorseStyle getHorseStyle(EntityHorse horse) {
        return SpongeEntityConstants.HORSE_STYLE_IDMAP.get((horse.func_110202_bQ() & 0xFF00) >> 8);
    }

    public static HorseStyle getHorseStyle(DataView container) {
        return SpongeImpl.getRegistry().getType(HorseStyle.class, DataUtil.getData(container, Keys.HORSE_STYLE, String.class)).get();
    }
}

